/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.HiDPIScaledGraphics;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBHiDPIScaledImage
extends BufferedImage {
    @Nullable
    private final Image myImage;
    private final int myUserWidth;
    private final int myUserHeight;
    private final float myScale;

    public JBHiDPIScaledImage(int width, int height, int type) {
        this((GraphicsConfiguration)null, width, height, type);
    }

    public JBHiDPIScaledImage(@Nullable Graphics2D g, int width, int height, int type) {
        super((int)((float)width * JBUI.sysScale(g)), (int)((float)height * JBUI.sysScale(g)), type);
        this.myImage = null;
        this.myUserWidth = width;
        this.myUserHeight = height;
        this.myScale = JBUI.sysScale(g);
    }

    public JBHiDPIScaledImage(@Nullable GraphicsConfiguration gc, int width, int height, int type) {
        super((int)((float)width * JBUI.sysScale(gc)), (int)((float)height * JBUI.sysScale(gc)), type);
        this.myImage = null;
        this.myUserWidth = width;
        this.myUserHeight = height;
        this.myScale = JBUI.sysScale(gc);
    }

    public JBHiDPIScaledImage(@NotNull Image image, int width, int height, int type) {
        super(1, 1, type);
        this.myImage = image;
        this.myUserWidth = width;
        this.myUserHeight = height;
        this.myScale = this.myUserWidth > 0 ? (float)(this.myImage.getWidth(null) / this.myUserWidth) : 1.0f;
    }

    public float getScale() {
        return this.myScale;
    }

    public JBHiDPIScaledImage scale(float scaleFactor) {
        Image img = this.myImage == null ? this : this.myImage;
        int w = (int)(scaleFactor * (float)this.getRealWidth(null));
        int h = (int)(scaleFactor * (float)this.getRealHeight(null));
        if (w <= 0 || h <= 0) {
            return this;
        }
        BufferedImage scaled = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(img), (Scalr.Method)Scalr.Method.QUALITY, (int)w, (int)h, (BufferedImageOp[])new BufferedImageOp[0]);
        int newUserWidth = (int)((float)w / this.myScale);
        int newUserHeight = (int)((float)h / this.myScale);
        if (this.myImage != null) {
            return new JBHiDPIScaledImage(scaled, newUserWidth, newUserHeight, this.getType());
        }
        JBHiDPIScaledImage newImg = new JBHiDPIScaledImage(newUserWidth, newUserHeight, this.getType());
        Graphics2D g = newImg.createGraphics();
        g.drawImage(scaled, 0, 0, newUserWidth, newUserHeight, 0, 0, ((Image)scaled).getWidth(null), ((Image)scaled).getHeight(null), null);
        g.dispose();
        return newImg;
    }

    public Image getDelegate() {
        return this.myImage;
    }

    @Override
    public int getWidth() {
        return this.getWidth(null);
    }

    @Override
    public int getHeight() {
        return this.getHeight(null);
    }

    @Override
    public int getWidth(ImageObserver observer) {
        return this.myImage != null ? this.getUserWidth(observer) : this.getRealWidth(observer);
    }

    @Override
    public int getHeight(ImageObserver observer) {
        return this.myImage != null ? this.getUserHeight(observer) : this.getRealHeight(observer);
    }

    public int getUserWidth(ImageObserver observer) {
        return this.myImage != null ? this.myUserWidth : (int)((float)super.getWidth(observer) / this.myScale);
    }

    public int getUserHeight(ImageObserver observer) {
        return this.myImage != null ? this.myUserHeight : (int)((float)super.getHeight(observer) / this.myScale);
    }

    public int getRealWidth(ImageObserver observer) {
        return this.myImage != null ? this.myImage.getWidth(observer) : super.getWidth(observer);
    }

    public int getRealHeight(ImageObserver observer) {
        return this.myImage != null ? this.myImage.getHeight(observer) : super.getHeight(observer);
    }

    @Override
    public Graphics2D createGraphics() {
        Graphics2D g = super.createGraphics();
        if (this.myImage == null) {
            return new HiDPIScaledGraphics(g);
        }
        return g;
    }
}

