/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.AppleHiDPIScaledImage;
import com.intellij.util.ImageLoader;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ui.UIUtil;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import org.jetbrains.annotations.NotNull;

public class RetinaImage {
    public static Image createFrom(Image image) {
        return RetinaImage.createFrom(image, 2, (ImageObserver)ImageLoader.ourComponent);
    }

    @NotNull
    public static Image createFrom(Image image, int scale, ImageObserver observer) {
        return RetinaImage.createFrom(image, (float)scale, observer);
    }

    @NotNull
    public static Image createFrom(Image image, float scale, ImageObserver observer) {
        int w = image.getWidth(observer);
        int h = image.getHeight(observer);
        JBHiDPIScaledImage hidpi = new JBHiDPIScaledImage(image, (int)((float)w / scale), (int)((float)h / scale), 2);
        if (SystemInfo.isAppleJvm) {
            Graphics2D g = (Graphics2D)((Image)hidpi).getGraphics();
            g.scale(1.0f / scale, 1.0f / scale);
            g.drawImage(image, 0, 0, null);
            g.dispose();
        }
        return hidpi;
    }

    @NotNull
    public static BufferedImage create(int width, int height, int type) {
        return new JBHiDPIScaledImage(width, height, type);
    }

    @NotNull
    public static BufferedImage create(Graphics2D g, int width, int height, int type) {
        return new JBHiDPIScaledImage(g, width, height, type);
    }

    @NotNull
    public static BufferedImage create(GraphicsConfiguration gc, int width, int height, int type) {
        return new JBHiDPIScaledImage(gc, width, height, type);
    }

    public static boolean isAppleHiDPIScaledImage(Image image) {
        return UIUtil.isAppleRetina() && AppleHiDPIScaledImage.is(image);
    }
}

