/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import org.jetbrains.annotations.NotNull;

class ConcurrentSoftKeySoftValueHashMap<K, V>
extends ConcurrentWeakKeySoftValueHashMap<K, V> {
    ConcurrentSoftKeySoftValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        super(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    @Override
    @NotNull
    protected ConcurrentWeakKeySoftValueHashMap.KeyReference<K, V> createKeyReference(@NotNull K k, @NotNull V v) {
        ConcurrentWeakKeySoftValueHashMap.ValueReference valueReference = this.createValueReference(v, this.myValueQueue);
        SoftKey<K, V> keyReference = new SoftKey<K, V>(k, valueReference, this.myHashingStrategy, this.myKeyQueue);
        if (valueReference instanceof ConcurrentWeakKeySoftValueHashMap.SoftValue) {
            ((ConcurrentWeakKeySoftValueHashMap.SoftValue)valueReference).myKeyReference = keyReference;
        }
        return keyReference;
    }

    private static class SoftKey<K, V>
    extends SoftReference<K>
    implements ConcurrentWeakKeySoftValueHashMap.KeyReference<K, V> {
        private final int myHash;
        private final TObjectHashingStrategy<K> myStrategy;
        @NotNull
        private final ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> myValueReference;

        SoftKey(@NotNull K k, @NotNull ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> valueReference, @NotNull TObjectHashingStrategy<K> strategy, @NotNull ReferenceQueue<K> queue) {
            super(k, queue);
            this.myValueReference = valueReference;
            this.myHash = strategy.computeHashCode(k);
            this.myStrategy = strategy;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConcurrentWeakKeySoftValueHashMap.KeyReference)) {
                return false;
            }
            Object t = this.get();
            Object other = ((ConcurrentWeakKeySoftValueHashMap.KeyReference)o).get();
            if (t == null || other == null) {
                return false;
            }
            if (t == other) {
                return true;
            }
            return this.myHash == o.hashCode() && this.myStrategy.equals(t, other);
        }

        @Override
        public int hashCode() {
            return this.myHash;
        }

        @Override
        @NotNull
        public ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> getValueReference() {
            return this.myValueReference;
        }
    }
}

