/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Getter;
import com.intellij.reference.SoftReference;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class ConcurrentWeakKeySoftValueHashMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<KeyReference<K, V>, ValueReference<K, V>> myMap;
    final ReferenceQueue<K> myKeyQueue;
    final ReferenceQueue<V> myValueQueue;
    @NotNull
    final TObjectHashingStrategy<K> myHashingStrategy;
    private static final ThreadLocal<HardKey> HARD_KEY = new ThreadLocal<HardKey>(){

        @Override
        protected HardKey initialValue() {
            return new HardKey();
        }
    };

    /*
     * Exception decompiling
     */
    public ConcurrentWeakKeySoftValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    protected KeyReference<K, V> createKeyReference(@NotNull K k, @NotNull V v) {
        ValueReference<K, V> valueReference = this.createValueReference(v, this.myValueQueue);
        WeakKey<K, V> keyReference = new WeakKey<K, V>(k, valueReference, this.myHashingStrategy, this.myKeyQueue);
        if (valueReference instanceof SoftValue) {
            ((SoftValue)valueReference).myKeyReference = keyReference;
        }
        return keyReference;
    }

    @NotNull
    protected ValueReference<K, V> createValueReference(@NotNull V value, @NotNull ReferenceQueue<V> queue) {
        return new SoftValue(value, queue);
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public void clear() {
        this.processQueues();
        this.myMap.clear();
    }

    @NotNull
    private HardKey<K, V> createHardKey(Object o) {
        Object key = o;
        HardKey hardKey = HARD_KEY.get();
        hardKey.set(key, this.myHashingStrategy.computeHashCode(key));
        return hardKey;
    }

    @Override
    public V get(@NotNull Object key) {
        HardKey<K, V> hardKey = this.createHardKey(key);
        ValueReference valueReference = (ValueReference)this.myMap.get(hardKey);
        Object v = SoftReference.deref(valueReference);
        ((HardKey)hardKey).clear();
        return (V)v;
    }

    @Override
    public boolean containsKey(Object key) {
        HardKey<K, V> hardKey = this.createHardKey(key);
        boolean result = this.myMap.containsKey(hardKey);
        ((HardKey)hardKey).clear();
        return result;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        this.processQueues();
        HardKey<K, V> hardKey = this.createHardKey(key);
        ValueReference valueReference = (ValueReference)this.myMap.remove(hardKey);
        Object v = SoftReference.deref(valueReference);
        ((HardKey)hardKey).clear();
        return (V)v;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V put(K key, V value) {
        this.processQueues();
        KeyReference<K, V> keyReference = this.createKeyReference(key, value);
        ValueReference<K, V> valueReference = keyReference.getValueReference();
        ValueReference<K, V> prevValReference = this.myMap.put(keyReference, valueReference);
        return (V)SoftReference.deref(prevValReference);
    }

    private boolean processQueues() {
        ValueReference valueReference;
        KeyReference keyReference;
        boolean removed = false;
        while ((keyReference = (KeyReference)((Object)this.myKeyQueue.poll())) != null) {
            valueReference = keyReference.getValueReference();
            removed |= this.myMap.remove(keyReference, valueReference);
        }
        while ((valueReference = (ValueReference)((Object)this.myValueQueue.poll())) != null) {
            keyReference = valueReference.getKeyReference();
            removed |= this.myMap.remove(keyReference, valueReference);
        }
        return removed;
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(@NotNull Object key, @NotNull Object value) {
        this.processQueues();
        HardKey<K, V> hardKey = this.createHardKey(key);
        ValueReference valueReference = (ValueReference)this.myMap.get(hardKey);
        Object v = SoftReference.deref(valueReference);
        boolean result = value.equals(v) && this.myMap.remove(hardKey, valueReference);
        ((HardKey)hardKey).clear();
        return result;
    }

    @Override
    public V putIfAbsent(@NotNull K key, @NotNull V value) {
        this.processQueues();
        KeyReference<K, V> keyReference = this.createKeyReference(key, value);
        ValueReference<K, V> valueReference = keyReference.getValueReference();
        ValueReference<K, V> result = this.myMap.putIfAbsent(keyReference, valueReference);
        return (V)SoftReference.deref(result);
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        this.processQueues();
        KeyReference<K, V> oldKeyReference = this.createKeyReference(key, oldValue);
        ValueReference<K, V> oldValueReference = oldKeyReference.getValueReference();
        KeyReference<K, V> newKeyReference = this.createKeyReference(key, newValue);
        ValueReference<K, V> newValueReference = newKeyReference.getValueReference();
        return this.myMap.replace(oldKeyReference, oldValueReference, newValueReference);
    }

    @Override
    public V replace(@NotNull K key, @NotNull V value) {
        this.processQueues();
        KeyReference<K, V> keyReference = this.createKeyReference(key, value);
        ValueReference<K, V> valueReference = keyReference.getValueReference();
        ValueReference<K, V> result = this.myMap.replace(keyReference, valueReference);
        return (V)SoftReference.deref(result);
    }

    private static class HardKey<K, V>
    implements KeyReference<K, V> {
        private K myKey;
        private int myHash;

        private HardKey() {
        }

        private void set(@NotNull K key, int hash) {
            this.myKey = key;
            this.myHash = hash;
        }

        private void clear() {
            this.myKey = null;
        }

        @Override
        public K get() {
            return this.myKey;
        }

        @Override
        public boolean equals(Object o) {
            return o.equals(this);
        }

        @Override
        public int hashCode() {
            return this.myHash;
        }

        @Override
        @NotNull
        public ValueReference<K, V> getValueReference() {
            throw new UnsupportedOperationException();
        }
    }

    static class SoftValue<K, V>
    extends java.lang.ref.SoftReference<V>
    implements ValueReference<K, V> {
        @NotNull
        volatile KeyReference<K, V> myKeyReference;

        private SoftValue(@NotNull V value, @NotNull ReferenceQueue<V> queue) {
            super(value, queue);
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            Object v = this.get();
            Object thatV = ((ValueReference)o).get();
            return v != null && thatV != null && v.equals(thatV);
        }

        @Override
        @NotNull
        public KeyReference<K, V> getKeyReference() {
            return this.myKeyReference;
        }
    }

    static class WeakKey<K, V>
    extends WeakReference<K>
    implements KeyReference<K, V> {
        private final int myHash;
        private final TObjectHashingStrategy<K> myStrategy;
        @NotNull
        private final ValueReference<K, V> myValueReference;

        WeakKey(@NotNull K k, @NotNull ValueReference<K, V> valueReference, @NotNull TObjectHashingStrategy<K> strategy, @NotNull ReferenceQueue<K> queue) {
            super(k, queue);
            this.myValueReference = valueReference;
            this.myHash = strategy.computeHashCode(k);
            this.myStrategy = strategy;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof KeyReference)) {
                return false;
            }
            Object t = this.get();
            Object other = ((KeyReference)o).get();
            if (t == null || other == null) {
                return false;
            }
            if (t == other) {
                return true;
            }
            return this.myHash == o.hashCode() && this.myStrategy.equals(t, other);
        }

        @Override
        public int hashCode() {
            return this.myHash;
        }

        @Override
        @NotNull
        public ValueReference<K, V> getValueReference() {
            return this.myValueReference;
        }
    }

    public static interface ValueReference<K, V>
    extends Getter<V> {
        @NotNull
        public KeyReference<K, V> getKeyReference();

        @Override
        public V get();
    }

    public static interface KeyReference<K, V>
    extends Getter<K> {
        @Override
        public K get();

        @NotNull
        public ValueReference<K, V> getValueReference();

        public boolean equals(Object var1);

        public int hashCode();
    }
}

