/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.containers.TreeTraversal;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FilteredTraverserBase<T, Self extends FilteredTraverserBase<T, Self>>
implements Iterable<T> {
    protected final Meta<T> meta;
    protected final Function<T, ? extends Iterable<? extends T>> tree;

    protected FilteredTraverserBase(@Nullable Meta<T> meta, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
        this.tree = tree;
        this.meta = meta == null ? Meta.empty() : meta;
    }

    @NotNull
    public final T getRoot() {
        return this.meta.roots.iterator().next();
    }

    @NotNull
    public final Iterable<? extends T> getRoots() {
        return this.meta.roots;
    }

    @Override
    public final Iterator<T> iterator() {
        return this.traverse().iterator();
    }

    @NotNull
    protected abstract Self newInstance(Meta<T> var1);

    @NotNull
    public final JBIterable<T> traverse(@NotNull TreeTraversal traversal) {
        Function adjusted = new Function<T, Iterable<? extends T>>(){

            @Override
            public Iterable<? extends T> fun(T t) {
                return FilteredTraverserBase.this.children(t);
            }
        };
        return this.meta.interceptor.fun(traversal).traversal(this.getRoots(), adjusted).filter(this.meta.filter.AND);
    }

    @NotNull
    public final JBIterable<T> traverse() {
        return this.traverse(this.meta.traversal);
    }

    @NotNull
    public final JBIterable<T> preOrderDfsTraversal() {
        return this.traverse(TreeTraversal.PRE_ORDER_DFS);
    }

    @NotNull
    public final JBIterable<T> postOrderDfsTraversal() {
        return this.traverse(TreeTraversal.POST_ORDER_DFS);
    }

    @NotNull
    public final JBIterable<T> bfsTraversal() {
        return this.traverse(TreeTraversal.PLAIN_BFS);
    }

    @NotNull
    public final JBIterable<T> tracingBfsTraversal() {
        return this.traverse(TreeTraversal.TRACING_BFS);
    }

    @NotNull
    public final Self reset() {
        return this.newInstance(this.meta.reset());
    }

    @NotNull
    public final Self withRoot(@Nullable T root) {
        return this.newInstance(this.meta.withRoots(ContainerUtil.createMaybeSingletonList(root)));
    }

    @NotNull
    public final Self withRoots(@NotNull Iterable<? extends T> roots) {
        return this.newInstance(this.meta.withRoots(roots));
    }

    @NotNull
    public final Self withTraversal(TreeTraversal type) {
        return this.newInstance(this.meta.withTraversal(type));
    }

    @NotNull
    public final Self expand(@NotNull Condition<? super T> c) {
        return this.newInstance(this.meta.expand(c));
    }

    @NotNull
    public final Self regard(@NotNull Condition<? super T> c) {
        return this.newInstance(this.meta.regard(c));
    }

    @NotNull
    public final Self expandAndFilter(Condition<? super T> c) {
        return this.newInstance(this.meta.expand(c).filter(c));
    }

    @NotNull
    public final Self expandAndSkip(Condition<? super T> c) {
        return this.newInstance(this.meta.expand(c).filter(Conditions.not(c)));
    }

    @NotNull
    public final Self filter(@NotNull Condition<? super T> c) {
        return this.newInstance(this.meta.filter(c));
    }

    @NotNull
    public final <C> JBIterable<C> filter(@NotNull Class<C> type) {
        return this.traverse().filter(type);
    }

    @NotNull
    public final Self unique() {
        return this.unique(Functions.identity());
    }

    @NotNull
    public final Self unique(final @NotNull Function<? super T, Object> identity) {
        return this.interceptTraversal(new Function<TreeTraversal, TreeTraversal>(){

            @Override
            public TreeTraversal fun(TreeTraversal traversal) {
                return traversal.unique(identity);
            }
        });
    }

    @NotNull
    public Self onRange(final @NotNull Condition<? super T> rangeCondition) {
        return this.interceptTraversal(new Function<TreeTraversal, TreeTraversal>(){

            @Override
            public TreeTraversal fun(TreeTraversal traversal) {
                return traversal.onRange(rangeCondition);
            }
        });
    }

    @NotNull
    public final Self forceIgnore(@NotNull Condition<? super T> c) {
        return this.newInstance(this.meta.forceIgnore(c));
    }

    @NotNull
    public final Self forceDisregard(@NotNull Condition<? super T> c) {
        return this.newInstance(this.meta.forceDisregard(c));
    }

    @NotNull
    public final Self interceptTraversal(@NotNull Function<TreeTraversal, TreeTraversal> transform) {
        return this.newInstance(this.meta.interceptTraversal(transform));
    }

    @NotNull
    public final JBIterable<T> children(@Nullable T node) {
        if (node == null || this.isAlwaysLeaf(node)) {
            return JBIterable.empty();
        }
        if (this.meta.regard.next == null && this.meta.forceDisregard.next == null) {
            return JBIterable.from(this.tree.fun(node)).filter(Conditions.not(this.meta.forceIgnore.OR));
        }
        return TreeTraversal.GUIDED_TRAVERSAL(this.meta.createChildrenGuide(node)).traversal(node, this.tree);
    }

    protected boolean isAlwaysLeaf(@NotNull T node) {
        return !this.meta.expand.valueAnd(node);
    }

    @NotNull
    public final List<T> toList() {
        return this.traverse().toList();
    }

    @NotNull
    public final Set<T> toSet() {
        return this.traverse().toSet();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{traversal=" + this.meta.traversal + '}';
    }

    private static class Cond<T> {
        static final Cond TRUE = new Cond<Object>(Conditions.TRUE, null);
        static final Cond FALSE = new Cond<Object>(Conditions.FALSE, null);
        final Condition<? super T> impl;
        final Cond<T> next;
        final Condition<? super T> OR = new Condition<T>(){

            @Override
            public boolean value(T t) {
                return Cond.this.valueOr(t);
            }
        };
        final Condition<? super T> AND = new Condition<T>(){

            @Override
            public boolean value(T t) {
                return Cond.this.valueAnd(t);
            }
        };

        Cond(Condition<? super T> impl, Cond<T> next) {
            this.impl = impl;
            this.next = next;
        }

        Cond<T> append(Condition<? super T> impl) {
            return new Cond<T>(impl, this);
        }

        boolean valueAnd(T t) {
            Cond<T> c = this;
            while (c != null) {
                if (!c.impl.value(t)) {
                    return false;
                }
                c = c.next;
            }
            return true;
        }

        boolean valueOr(T t) {
            Cond<T> c = this;
            while (c != null) {
                if (c.impl.value(t)) {
                    return true;
                }
                c = c.next;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Cond{");
            Cond<T> c = this;
            while (c != null) {
                sb.append(JBIterator.toShortString(c.impl));
                if (c.next != null) {
                    sb.append(", ");
                }
                c = c.next;
            }
            return sb.append("}").toString();
        }
    }

    protected static class Meta<T> {
        final TreeTraversal traversal;
        final Iterable<? extends T> roots;
        final Cond<T> expand;
        final Cond<T> regard;
        final Cond<T> filter;
        final Cond<T> forceIgnore;
        final Cond<T> forceDisregard;
        final Function<TreeTraversal, TreeTraversal> interceptor;
        private static final Meta<?> EMPTY = new Meta(JBIterable.empty(), TreeTraversal.PRE_ORDER_DFS, Cond.TRUE, Cond.TRUE, Cond.TRUE, Cond.FALSE, Cond.FALSE, Functions.<TreeTraversal>id());

        public Meta(@NotNull Iterable<? extends T> roots, @NotNull TreeTraversal traversal, @NotNull Cond<T> expand, @NotNull Cond<T> regard, @NotNull Cond<T> filter, @NotNull Cond<T> forceIgnore, @NotNull Cond<T> forceDisregard, @NotNull Function<TreeTraversal, TreeTraversal> interceptor) {
            this.roots = roots;
            this.traversal = traversal;
            this.expand = expand;
            this.regard = regard;
            this.filter = filter;
            this.forceIgnore = forceIgnore;
            this.forceDisregard = forceDisregard;
            this.interceptor = interceptor;
        }

        public Meta<T> reset() {
            Meta<T> e = Meta.empty();
            return new Meta<T>(this.roots, e.traversal, e.expand, e.regard, e.filter, this.forceIgnore, this.forceDisregard, e.interceptor);
        }

        public Meta<T> withRoots(@NotNull Iterable<? extends T> roots) {
            return new Meta<T>(roots, this.traversal, this.expand, this.regard, this.filter, this.forceIgnore, this.forceDisregard, this.interceptor);
        }

        public Meta<T> withTraversal(TreeTraversal traversal) {
            return new Meta<T>(this.roots, traversal, this.expand, this.regard, this.filter, this.forceIgnore, this.forceDisregard, this.interceptor);
        }

        public Meta<T> expand(@NotNull Condition<? super T> c) {
            return new Meta<T>(this.roots, this.traversal, this.expand.append(c), this.regard, this.filter, this.forceIgnore, this.forceDisregard, this.interceptor);
        }

        public Meta<T> regard(@NotNull Condition<? super T> c) {
            return new Meta<T>(this.roots, this.traversal, this.expand, this.regard.append(c), this.filter, this.forceIgnore, this.forceDisregard, this.interceptor);
        }

        public Meta<T> filter(@NotNull Condition<? super T> c) {
            return new Meta<T>(this.roots, this.traversal, this.expand, this.regard, this.filter.append(c), this.forceIgnore, this.forceDisregard, this.interceptor);
        }

        public Meta<T> forceIgnore(Condition<? super T> c) {
            return new Meta<T>(this.roots, this.traversal, this.expand, this.regard, this.filter, this.forceIgnore.append(c), this.forceDisregard, this.interceptor);
        }

        public Meta<T> forceDisregard(Condition<? super T> c) {
            return new Meta<T>(this.roots, this.traversal, this.expand, this.regard, this.filter, this.forceIgnore, this.forceDisregard.append(c), this.interceptor);
        }

        public Meta<T> interceptTraversal(Function<TreeTraversal, TreeTraversal> transform) {
            if (transform == Function.ID) {
                return this;
            }
            Function<TreeTraversal, TreeTraversal> newTransform = this.interceptor == Function.ID ? transform : Functions.compose(this.interceptor, transform);
            return new Meta<T>(this.roots, this.traversal, this.expand, this.regard, this.filter, this.forceIgnore, this.forceDisregard, newTransform);
        }

        TreeTraversal.GuidedIt.Guide<T> createChildrenGuide(final T parent) {
            return new TreeTraversal.GuidedIt.Guide<T>(){
                final Condition<? super T> expand;
                {
                    this.expand = Meta.this.buildExpandConditionForChildren(parent);
                }

                @Override
                public void guide(@NotNull TreeTraversal.GuidedIt<T> guidedIt) {
                    Meta.this.doPerformChildrenGuidance(guidedIt, this.expand);
                }
            };
        }

        private void doPerformChildrenGuidance(TreeTraversal.GuidedIt<T> it, Condition<? super T> expand) {
            if (it.curChild == null) {
                return;
            }
            if (this.forceIgnore.valueOr(it.curChild)) {
                return;
            }
            if (it.curParent == null || expand.value(it.curChild)) {
                it.queueNext(it.curChild);
            } else {
                it.result(it.curChild);
            }
        }

        private Condition<? super T> buildExpandConditionForChildren(T parent) {
            Cond copy = null;
            boolean invert = true;
            Cond<T> c = this.regard;
            while (c != null) {
                Condition impl = JBIterable.Stateful.copy(c.impl);
                if (impl != (invert ? Condition.TRUE : Condition.FALSE)) {
                    copy = new Cond(invert ? Conditions.not(impl) : impl, copy);
                    if (impl instanceof EdgeFilter) {
                        ((EdgeFilter)impl).edgeSource = parent;
                    }
                }
                if (c.next == null) {
                    c = invert ? this.forceDisregard : null;
                    invert = false;
                    continue;
                }
                c = c.next;
            }
            return copy == null ? Condition.FALSE : copy.OR;
        }

        public static <T> Meta<T> empty() {
            return EMPTY;
        }
    }

    public static abstract class EdgeFilter<T>
    extends JBIterable.StatefulFilter<T> {
        protected T edgeSource;
    }
}

