/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.OpenTHashSet;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public class HashSetQueue<T>
extends AbstractCollection<T>
implements Queue<T> {
    private final OpenTHashSet<QueueEntry<T>> set = new OpenTHashSet();
    private final QueueEntry<T> TOMB = new QueueEntry<T>(this.cast(new Object()));

    public HashSetQueue() {
        ((QueueEntry)this.TOMB).next = (((QueueEntry)this.TOMB).prev = (QueueEntry)this.TOMB);
    }

    @Override
    public boolean offer(@NotNull T t) {
        return this.add(t);
    }

    @Override
    public boolean add(@NotNull T t) {
        QueueEntry<T> newLast = new QueueEntry<T>(t);
        boolean added = this.set.add(newLast);
        if (!added) {
            return false;
        }
        QueueEntry oldLast = ((QueueEntry)this.TOMB).prev;
        oldLast.next = (QueueEntry)newLast;
        ((QueueEntry)newLast).prev = oldLast;
        ((QueueEntry)newLast).next = (QueueEntry)this.TOMB;
        ((QueueEntry)this.TOMB).prev = (QueueEntry)newLast;
        return true;
    }

    @Override
    @NotNull
    public T remove() {
        T poll = this.poll();
        if (poll == null) {
            throw new NoSuchElementException();
        }
        return poll;
    }

    @Override
    public T poll() {
        T peek = this.peek();
        if (peek != null) {
            this.remove(peek);
        }
        return peek;
    }

    @Override
    @NotNull
    public T element() {
        T peek = this.peek();
        if (peek == null) {
            throw new NoSuchElementException();
        }
        return peek;
    }

    @Override
    public T peek() {
        return (T)(((QueueEntry)this.TOMB).next == this.TOMB ? null : ((QueueEntry)this.TOMB).next.t);
    }

    public T find(@NotNull T t) {
        QueueEntry<T> existing = this.findEntry(t);
        return (T)(existing == null ? null : ((QueueEntry)existing).t);
    }

    private QueueEntry<T> findEntry(@NotNull T t) {
        return this.set.get(new QueueEntry<T>(t));
    }

    @Override
    public boolean remove(Object o) {
        T t = this.cast(o);
        QueueEntry<T> entry = this.findEntry(t);
        if (entry == null) {
            return false;
        }
        QueueEntry prev = ((QueueEntry)entry).prev;
        QueueEntry next = ((QueueEntry)entry).next;
        prev.next = next;
        next.prev = prev;
        this.set.remove(entry);
        return true;
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean contains(Object o) {
        return this.find(this.cast(o)) != null;
    }

    private T cast(Object o) {
        return (T)o;
    }

    @Override
    @NotNull
    public PositionalIterator<T> iterator() {
        return new PositionalIterator<T>(){
            private QueueEntry<T> cursor;
            private long count;
            {
                this.cursor = HashSetQueue.this.TOMB;
            }

            @Override
            public boolean hasNext() {
                return this.cursor.next != HashSetQueue.this.TOMB;
            }

            @Override
            public T next() {
                this.cursor = this.cursor.next;
                ++this.count;
                return this.cursor.t;
            }

            @Override
            public void remove() {
                if (this.cursor == HashSetQueue.this.TOMB) {
                    throw new NoSuchElementException();
                }
                HashSetQueue.this.remove(this.cursor.t);
            }

            @Override
            @NotNull
            public PositionalIterator.IteratorPosition<T> position() {
                return new MyIteratorPosition(this.cursor, this.count, HashSetQueue.this.TOMB);
            }
        };
    }

    public static interface PositionalIterator<T>
    extends Iterator<T> {
        @NotNull
        public IteratorPosition<T> position();

        public static interface IteratorPosition<T>
        extends Comparable<IteratorPosition<T>> {
            public T peek();

            public IteratorPosition<T> next();
        }
    }

    private static class MyIteratorPosition<T>
    implements PositionalIterator.IteratorPosition<T> {
        private final QueueEntry<T> cursor;
        private final long count;
        private final QueueEntry<T> TOMB;

        private MyIteratorPosition(@NotNull QueueEntry<T> cursor, long count, QueueEntry<T> TOMB) {
            this.cursor = cursor;
            this.count = count;
            this.TOMB = TOMB;
        }

        @Override
        public T peek() {
            if (this.cursor == this.TOMB) {
                throw new IllegalStateException("Iterator is before the first element. Must call .next() first.");
            }
            return (T)((QueueEntry)this.cursor).t;
        }

        @Override
        public PositionalIterator.IteratorPosition<T> next() {
            return ((QueueEntry)this.cursor).next == this.TOMB ? null : new MyIteratorPosition<T>(((QueueEntry)this.cursor).next, this.count + 1L, this.TOMB);
        }

        @Override
        public int compareTo(@NotNull PositionalIterator.IteratorPosition<T> o) {
            return MyIteratorPosition.compare(this.count, ((MyIteratorPosition)o).count);
        }

        private static int compare(long x, long y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }
    }

    private static class QueueEntry<T> {
        @NotNull
        private final T t;
        private QueueEntry<T> next;
        private QueueEntry<T> prev;

        public QueueEntry(@NotNull T t) {
            this.t = t;
        }

        public int hashCode() {
            return this.t.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof QueueEntry && this.t.equals(((QueueEntry)obj).t);
        }
    }
}

