/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.PairFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.JBIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JBIterable<E>
implements Iterable<E> {
    final Iterable<E> myIterable;
    private static final JBIterable EMPTY = new JBIterable(){

        @Override
        public Iterator iterator() {
            return EmptyIterator.getInstance();
        }
    };

    protected JBIterable() {
        this.myIterable = this;
    }

    JBIterable(@NotNull Iterable<E> iterable) {
        this.myIterable = iterable;
    }

    @NotNull
    public static <E> JBIterable<E> from(@Nullable Iterable<? extends E> iterable) {
        if (iterable == null) {
            return JBIterable.empty();
        }
        if (iterable instanceof JBIterable) {
            return (JBIterable)iterable;
        }
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            return JBIterable.empty();
        }
        return new JBIterable<E>(iterable){

            @Override
            public Iterator<E> iterator() {
                return this.myIterable.iterator();
            }
        };
    }

    @NotNull
    public static <E> JBIterable<E> generate(final @Nullable E first, final @NotNull Function<? super E, ? extends E> generator) {
        if (first == null) {
            return JBIterable.empty();
        }
        return new JBIterable<E>(){

            @Override
            public Iterator<E> iterator() {
                final Function fun = Stateful.copy(generator);
                return new JBIterator<E>(){
                    E cur;
                    {
                        this.cur = first;
                    }

                    @Override
                    public E nextImpl() {
                        Object result = this.cur;
                        if (result == null) {
                            return this.stop();
                        }
                        this.cur = fun.fun(this.cur);
                        return result;
                    }
                };
            }
        };
    }

    @NotNull
    public static <E> JBIterable<E> generate(final @Nullable E first1, final @Nullable E first2, final @NotNull PairFunction<? super E, ? super E, ? extends E> generator) {
        if (first1 == null) {
            return JBIterable.empty();
        }
        return new JBIterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new JBIterator<E>(){
                    E cur1;
                    E cur2;
                    {
                        this.cur1 = first1;
                        this.cur2 = first2;
                    }

                    @Override
                    public E nextImpl() {
                        Object result = this.cur1;
                        this.cur1 = this.cur2;
                        this.cur2 = generator.fun(result, this.cur2);
                        if (result == null) {
                            return this.stop();
                        }
                        return result;
                    }
                };
            }
        };
    }

    @NotNull
    public static <E> JBIterable<E> of(@Nullable E element) {
        return element == null ? JBIterable.empty() : JBIterable.from(Collections.singletonList(element));
    }

    @NotNull
    public static <E> JBIterable<E> of(E ... elements) {
        return elements == null || elements.length == 0 ? JBIterable.empty() : JBIterable.from(ContainerUtilRt.newArrayList(elements));
    }

    @NotNull
    public static <E> JBIterable<E> empty() {
        return EMPTY;
    }

    @NotNull
    public static <E> JBIterable<E> once(@NotNull Iterator<E> iterator) {
        return JBIterable.of(Ref.create(iterator)).intercept(new Function<Iterator<Ref<Iterator<E>>>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<Ref<Iterator<E>>> iterator) {
                Ref ref = iterator.next();
                Iterator result = ref.get();
                if (result == null) {
                    throw new UnsupportedOperationException();
                }
                ref.set(null);
                return result;
            }
        });
    }

    @NotNull
    public <T extends Iterator<E>> T typedIterator() {
        return (T)this.iterator();
    }

    public boolean processEach(@NotNull Processor<E> processor) {
        return ContainerUtil.process(this, processor);
    }

    public void consumeEach(@NotNull Consumer<E> consumer) {
        for (Object e : this) {
            consumer.consume(e);
        }
    }

    @NotNull
    public String toString() {
        return this.myIterable == this ? JBIterable.class.getSimpleName() : String.valueOf(this.myIterable);
    }

    public final int size() {
        if (this.myIterable instanceof Collection) {
            return ((Collection)this.myIterable).size();
        }
        int count = 0;
        for (E ignored : this.myIterable) {
            ++count;
        }
        return count;
    }

    public final boolean contains(@Nullable Object element) {
        if (this.myIterable instanceof Collection) {
            return ((Collection)this.myIterable).contains(element);
        }
        for (E e : this.myIterable) {
            if (!Comparing.equal(e, element)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public final E get(int index) {
        if (this.myIterable instanceof List) {
            return index >= ((List)this.myIterable).size() ? null : (E)((List)this.myIterable).get(index);
        }
        return this.skip(index).first();
    }

    @NotNull
    public final JBIterable<E> append(@Nullable Iterable<? extends E> other) {
        return other == null ? this : (this == EMPTY ? JBIterable.from(other) : JBIterable.of(this.myIterable, other).flatten(Functions.identity()));
    }

    @NotNull
    public final <T> JBIterable<E> append(@Nullable Iterable<T> other, @NotNull Function<? super T, ? extends Iterable<? extends E>> fun) {
        return other == null ? this : (this == EMPTY ? JBIterable.from(other).flatten(fun) : this.append((T)JBIterable.from(other).flatten(fun)));
    }

    @NotNull
    public final JBIterable<E> repeat(int count) {
        Function fun = Functions.identity();
        return JBIterable.generate(this, fun).take(count).flatten(fun);
    }

    @NotNull
    public final JBIterable<E> append(@NotNull E[] elements) {
        return this == EMPTY ? JBIterable.of(elements) : this.append((E)Arrays.asList(elements));
    }

    @NotNull
    public final JBIterable<E> append(@Nullable E e) {
        return e == null ? this : (this == EMPTY ? JBIterable.of(e) : this.append(Collections.singleton(e)));
    }

    @NotNull
    public final JBIterable<E> filter(final @NotNull Condition<? super E> condition) {
        return this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator) {
                return JBIterator.from(iterator).filter(Stateful.copy(condition));
            }
        });
    }

    @NotNull
    public final <T> JBIterable<T> filter(@NotNull Class<T> type) {
        return this.filter(Conditions.instanceOf(type));
    }

    @NotNull
    public final JBIterable<E> take(final int count) {
        return this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator) {
                return JBIterator.from(iterator).take(count);
            }
        });
    }

    @NotNull
    public final JBIterable<E> takeWhile(final @NotNull Condition<? super E> condition) {
        return this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator) {
                return JBIterator.from(iterator).takeWhile(Stateful.copy(condition));
            }
        });
    }

    @NotNull
    public final JBIterable<E> skip(final int count) {
        return this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator) {
                return JBIterator.from(iterator).skip(count);
            }
        });
    }

    @NotNull
    public final JBIterable<E> skipWhile(final @NotNull Condition<? super E> condition) {
        return this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator) {
                return JBIterator.from(iterator).skipWhile(Stateful.copy(condition));
            }
        });
    }

    @NotNull
    public final <T> JBIterable<T> transform(final @NotNull Function<? super E, T> function) {
        return this.intercept(new Function<Iterator<E>, Iterator<T>>(){

            @Override
            public Iterator<T> fun(Iterator<E> iterator) {
                return JBIterator.from(iterator).transform(Stateful.copy(function));
            }
        });
    }

    @NotNull
    public <T> JBIterable<T> flatten(final @NotNull Function<? super E, ? extends Iterable<? extends T>> function) {
        return this.intercept(new Function<Iterator<E>, Iterator<T>>(){

            @Override
            public Iterator<T> fun(final Iterator<E> iterator) {
                final Function fun = Stateful.copy(function);
                return new JBIterator<T>(){
                    Iterator<? extends T> cur;

                    @Override
                    public T nextImpl() {
                        if (this.cur != null && this.cur.hasNext()) {
                            return this.cur.next();
                        }
                        if (!iterator.hasNext()) {
                            return this.stop();
                        }
                        Iterable next = (Iterable)fun.fun(iterator.next());
                        this.cur = next == null ? null : next.iterator();
                        return this.skip();
                    }
                };
            }
        });
    }

    @NotNull
    public final JBIterable<E> unique() {
        return this.unique(Function.ID);
    }

    @NotNull
    public final JBIterable<E> unique(final @NotNull Function<? super E, ?> identity) {
        return this.filter(new StatefulFilter<E>(){
            HashSet<Object> visited;

            @Override
            public boolean value(E e) {
                if (this.visited == null) {
                    this.visited = new HashSet();
                }
                return this.visited.add(identity.fun(e));
            }
        });
    }

    @NotNull
    public final <T, X extends Iterator<E>> JBIterable<T> intercept(final @NotNull Function<X, ? extends Iterator<T>> function) {
        if (this == EMPTY) {
            return JBIterable.empty();
        }
        final JBIterable thisIterable = this;
        return new JBIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return (Iterator)function.fun(thisIterable.iterator());
            }
        };
    }

    @Nullable
    public final E first() {
        Iterator<E> iterator = this.myIterable.iterator();
        return iterator.hasNext() ? (E)iterator.next() : null;
    }

    @Nullable
    public final E last() {
        if (this.myIterable instanceof List) {
            return (E)ContainerUtil.getLastItem((List)this.myIterable);
        }
        Iterator<E> iterator = this.myIterable.iterator();
        E cur = null;
        while (iterator.hasNext()) {
            cur = iterator.next();
        }
        return cur;
    }

    public final <T> T reduce(@Nullable T first, @NotNull PairFunction<T, ? super E, T> function) {
        T cur = first;
        for (Object e : this) {
            cur = function.fun(cur, e);
        }
        return cur;
    }

    public final E find(@NotNull Condition<? super E> condition) {
        return this.filter(condition).first();
    }

    public final int indexOf(@NotNull Condition<? super E> condition) {
        int index = 0;
        for (Object e : this) {
            if (condition.value(e)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @NotNull
    public final <T> JBIterable<T> map(@NotNull Function<? super E, T> function) {
        return this.transform(function);
    }

    @NotNull
    public final <T> JBIterable<T> flatMap(Function<? super E, ? extends Iterable<? extends T>> function) {
        return this.map(function).flatten(Function.ID);
    }

    @NotNull
    public final JBIterable<List<E>> split(final int size, final boolean strict) {
        return this.split(size).map(new Function<JBIterable<E>, List<E>>(){

            @Override
            public List<E> fun(JBIterable<E> es) {
                List list = es.addAllTo(ContainerUtilRt.newArrayListWithCapacity(size));
                return strict && list.size() < size ? null : list;
            }
        }).filter(Condition.NOT_NULL);
    }

    @NotNull
    public final JBIterable<JBIterable<E>> split(final int size) {
        if (size <= 0) {
            throw new IllegalArgumentException(size + " <= 0");
        }
        return this.intercept(new Function<Iterator<E>, Iterator<JBIterable<E>>>(){

            @Override
            public Iterator<JBIterable<E>> fun(Iterator<E> iterator) {
                final Iterator orig = iterator;
                return new JBIterator<JBIterable<E>>(){
                    JBIterator<E> it;

                    @Override
                    protected JBIterable<E> nextImpl() {
                        JBIterable jBIterable;
                        while (this.it != null && this.it.advance()) {
                        }
                        this.it = null;
                        if (orig.hasNext()) {
                            this.it = JBIterator.wrap(orig);
                            jBIterable = JBIterable.once(this.it.take(size));
                        } else {
                            jBIterable = (JBIterable)this.stop();
                        }
                        return jBIterable;
                    }
                };
            }
        });
    }

    @NotNull
    public final JBIterable<JBIterable<E>> split(final Split mode, final Condition<? super E> separator) {
        return this.intercept(new Function<Iterator<E>, Iterator<JBIterable<E>>>(){

            @Override
            public Iterator<JBIterable<E>> fun(Iterator<E> iterator) {
                final Iterator orig = iterator;
                final Condition condition = Stateful.copy(separator);
                return new JBIterator<JBIterable<E>>(){
                    JBIterator<E> it;
                    E stored;
                    int st;

                    @Override
                    protected JBIterable<E> nextImpl() {
                        while (this.it != null && this.it.advance()) {
                        }
                        this.it = null;
                        if (this.stored == null && !orig.hasNext()) {
                            if (this.st < 0 && mode != Split.BEFORE && mode != Split.GROUP) {
                                this.st = 1;
                                return JBIterable.empty();
                            }
                            return (JBIterable)this.stop();
                        }
                        if (this.st == -2 && mode == Split.AROUND) {
                            this.st = -1;
                            return JBIterable.empty();
                        }
                        Object tmp = this.stored;
                        this.stored = null;
                        this.it = JBIterator.wrap(orig);
                        return JBIterable.of(tmp).append(JBIterable.once(this.it.takeWhile(new Condition<E>(){

                            @Override
                            public boolean value(E e) {
                                boolean result;
                                boolean sep = condition.value(e);
                                int st0 = st;
                                st = st0 < 0 && sep ? -2 : (st0 > 0 && !sep ? 2 : (sep ? -1 : 1));
                                switch (mode) {
                                    case AFTER: {
                                        result = st != -2 && (st != 1 || st0 == 0);
                                        break;
                                    }
                                    case BEFORE: {
                                        result = st != -2 && st != -1;
                                        break;
                                    }
                                    case AROUND: {
                                        result = st0 >= 0 && st > 0;
                                        break;
                                    }
                                    case GROUP: {
                                        result = st0 >= 0 && st > 0 || st0 <= 0 && st < 0;
                                        break;
                                    }
                                    case OFF: {
                                        result = st > 0;
                                        break;
                                    }
                                    default: {
                                        throw new AssertionError(st);
                                    }
                                }
                                stored = !result && mode != Split.OFF ? e : null;
                                return result;
                            }
                        })));
                    }
                };
            }
        });
    }

    public final boolean isEmpty() {
        if (this.myIterable instanceof Collection) {
            return ((Collection)this.myIterable).isEmpty();
        }
        return !this.myIterable.iterator().hasNext();
    }

    @NotNull
    public final List<E> toList() {
        return Collections.unmodifiableList(ContainerUtilRt.newArrayList(this.myIterable));
    }

    @NotNull
    public final Set<E> toSet() {
        return Collections.unmodifiableSet(ContainerUtilRt.newLinkedHashSet(this.myIterable));
    }

    @NotNull
    public final <V> Map<E, V> toMap(Convertor<E, V> valueFunction) {
        return Collections.unmodifiableMap(ContainerUtil.newMapFromKeys(this.iterator(), valueFunction));
    }

    @NotNull
    public final <C extends Collection<? super E>> C addAllTo(@NotNull C collection) {
        if (this.myIterable instanceof Collection) {
            collection.addAll((Collection)this.myIterable);
        } else {
            for (E item : this.myIterable) {
                collection.add(item);
            }
        }
        return collection;
    }

    public static abstract class StatefulTransform<S, T>
    extends Stateful<StatefulTransform>
    implements Function<S, T> {
    }

    public static abstract class StatefulFilter<T>
    extends Stateful<StatefulFilter>
    implements Condition<T> {
    }

    public static abstract class Stateful<Self extends Stateful>
    implements Cloneable {
        @NotNull
        static <T> T copy(@NotNull T o) {
            if (!(o instanceof Stateful)) {
                return o;
            }
            return (T)((Stateful)o).clone();
        }

        public Self clone() {
            try {
                return (Self)((Stateful)super.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static enum Split {
        AFTER,
        BEFORE,
        AROUND,
        OFF,
        GROUP;

    }
}

