/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class LimitedPool<T> {
    private final int maxCapacity;
    private final ObjectFactory<T> factory;
    private Object[] storage;
    private int index;

    public LimitedPool(int maxCapacity, @NotNull ObjectFactory<T> factory) {
        this.maxCapacity = maxCapacity;
        this.factory = factory;
        this.storage = new Object[10];
    }

    @NotNull
    public T alloc() {
        if (this.index == 0) {
            return this.factory.create();
        }
        int i = --this.index;
        Object result = this.storage[i];
        this.storage[i] = null;
        return (T)result;
    }

    public void recycle(@NotNull T t) {
        this.factory.cleanup(t);
        if (this.index >= this.maxCapacity) {
            return;
        }
        this.ensureCapacity();
        this.storage[this.index++] = t;
    }

    private void ensureCapacity() {
        if (this.storage.length <= this.index) {
            int newCapacity = Math.min(this.maxCapacity, this.storage.length * 3 / 2);
            this.storage = ArrayUtil.realloc(this.storage, newCapacity, ArrayUtil.OBJECT_ARRAY_FACTORY);
        }
    }

    public static interface ObjectFactory<T> {
        @NotNull
        public T create();

        public void cleanup(@NotNull T var1);
    }
}

