/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.OrderedSet;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.containers.WeakHashMap;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiMap<K, V>
implements Serializable {
    public static final MultiMap EMPTY = new EmptyMap();
    private static final long serialVersionUID = -2632269270151455493L;
    protected final Map<K, Collection<V>> myMap;
    private Collection<V> values;

    public MultiMap() {
        this.myMap = this.createMap();
    }

    public MultiMap(@NotNull MultiMap<? extends K, ? extends V> toCopy) {
        this();
        this.putAllValues(toCopy);
    }

    @NotNull
    public MultiMap<K, V> copy() {
        return new MultiMap<K, V>(this);
    }

    public MultiMap(int initialCapacity, float loadFactor) {
        this.myMap = this.createMap(initialCapacity, loadFactor);
    }

    @NotNull
    protected Map<K, Collection<V>> createMap() {
        return new HashMap();
    }

    @NotNull
    protected Map<K, Collection<V>> createMap(int initialCapacity, float loadFactor) {
        return new HashMap(initialCapacity, loadFactor);
    }

    @NotNull
    protected Collection<V> createCollection() {
        return new SmartList();
    }

    @NotNull
    protected Collection<V> createEmptyCollection() {
        return Collections.emptyList();
    }

    public <Kk extends K, Vv extends V> void putAllValues(@NotNull MultiMap<Kk, Vv> from) {
        for (Map.Entry<Kk, Collection<Vv>> entry : from.entrySet()) {
            this.putValues(entry.getKey(), entry.getValue());
        }
    }

    public void putValues(K key, @NotNull Collection<? extends V> values) {
        Collection<V> list = this.myMap.get(key);
        if (list == null) {
            list = this.createCollection();
            this.myMap.put(key, list);
        }
        list.addAll(values);
    }

    public void putValue(@Nullable K key, V value) {
        Collection<V> list = this.myMap.get(key);
        if (list == null) {
            list = this.createCollection();
            this.myMap.put(key, list);
        }
        list.add(value);
    }

    @NotNull
    public Set<Map.Entry<K, Collection<V>>> entrySet() {
        return this.myMap.entrySet();
    }

    public boolean isEmpty() {
        if (this.myMap.isEmpty()) {
            return true;
        }
        for (Collection<V> valueList : this.myMap.values()) {
            if (valueList.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean containsKey(K key) {
        return this.myMap.containsKey(key);
    }

    public boolean containsScalarValue(V value) {
        for (Collection<V> valueList : this.myMap.values()) {
            if (!valueList.contains(value)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Collection<V> get(K key) {
        Collection<V> collection = this.myMap.get(key);
        return collection == null ? this.createEmptyCollection() : collection;
    }

    @NotNull
    public Collection<V> getModifiable(K key) {
        Collection<V> collection = this.myMap.get(key);
        if (collection == null) {
            collection = this.createCollection();
            this.myMap.put(key, collection);
        }
        return collection;
    }

    @NotNull
    public Set<K> keySet() {
        return this.myMap.keySet();
    }

    public int size() {
        return this.myMap.size();
    }

    public void put(K key, Collection<V> values) {
        this.myMap.put(key, values);
    }

    public void removeValue(K key, V value) {
        this.remove(key, value);
    }

    public boolean remove(K key, V value) {
        Collection<V> values = this.myMap.get(key);
        if (values != null) {
            boolean removed = values.remove(value);
            if (values.isEmpty()) {
                this.myMap.remove(key);
            }
            return removed;
        }
        return false;
    }

    @NotNull
    public Collection<? extends V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                @NotNull
                public Iterator<V> iterator() {
                    return new Iterator<V>(){
                        private final Iterator<Collection<V>> mapIterator;
                        private Iterator<V> itr;
                        {
                            this.mapIterator = MultiMap.this.myMap.values().iterator();
                            this.itr = EmptyIterator.getInstance();
                        }

                        @Override
                        public boolean hasNext() {
                            while (!this.itr.hasNext()) {
                                if (!this.mapIterator.hasNext()) {
                                    return false;
                                }
                                this.itr = this.mapIterator.next().iterator();
                            }
                            return true;
                        }

                        @Override
                        public V next() {
                            while (!this.itr.hasNext()) {
                                if (!this.mapIterator.hasNext()) {
                                    throw new NoSuchElementException();
                                }
                                this.itr = this.mapIterator.next().iterator();
                            }
                            return this.itr.next();
                        }

                        @Override
                        public void remove() {
                            this.itr.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    int res = 0;
                    for (Collection vs : MultiMap.this.myMap.values()) {
                        res += vs.size();
                    }
                    return res;
                }

                @Override
                public boolean contains(Object o) {
                    for (Collection vs : MultiMap.this.myMap.values()) {
                        if (!vs.contains(o)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.values;
    }

    public void clear() {
        this.myMap.clear();
    }

    @Nullable
    public Collection<V> remove(K key) {
        return this.myMap.remove(key);
    }

    @NotNull
    public static <K, V> MultiMap<K, V> emptyInstance() {
        MultiMap empty = EMPTY;
        return empty;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> create() {
        return new MultiMap<K, V>();
    }

    @NotNull
    public static <K, V> MultiMap<K, V> create(final @NotNull TObjectHashingStrategy<K> strategy) {
        return new MultiMap<K, V>(){

            @Override
            @NotNull
            protected Map<K, Collection<V>> createMap() {
                return new THashMap(strategy);
            }
        };
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createLinked() {
        return new LinkedMultiMap();
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createLinkedSet() {
        return new LinkedMultiMap<K, V>(){

            @Override
            @NotNull
            protected Collection<V> createCollection() {
                return ContainerUtil.newLinkedHashSet();
            }
        };
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createOrderedSet() {
        return new LinkedMultiMap<K, V>(){

            @Override
            @NotNull
            protected Collection<V> createCollection() {
                return new OrderedSet();
            }
        };
    }

    @Deprecated
    @NotNull
    public static <K, V> MultiMap<K, V> createSmartList() {
        return MultiMap.createSmart();
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createSmart() {
        return new MultiMap<K, V>(){

            @Override
            @NotNull
            protected Map<K, Collection<V>> createMap() {
                return new THashMap();
            }
        };
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createConcurrentSet() {
        return new MultiMap<K, V>(){

            @Override
            @NotNull
            protected Collection<V> createCollection() {
                return ContainerUtil.newConcurrentSet();
            }

            @Override
            @NotNull
            protected Collection<V> createEmptyCollection() {
                return Collections.emptySet();
            }

            @Override
            @NotNull
            protected Map<K, Collection<V>> createMap() {
                return ContainerUtil.newConcurrentMap();
            }
        };
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createSet() {
        return MultiMap.createSet(TObjectHashingStrategy.CANONICAL);
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createSet(final TObjectHashingStrategy strategy) {
        return new MultiMap<K, V>(){

            @Override
            @NotNull
            protected Collection<V> createCollection() {
                return new SmartHashSet();
            }

            @Override
            @NotNull
            protected Collection<V> createEmptyCollection() {
                return Collections.emptySet();
            }

            @Override
            @NotNull
            protected Map<K, Collection<V>> createMap() {
                return new THashMap(strategy);
            }
        };
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createWeakKey() {
        return new MultiMap<K, V>(){

            @Override
            @NotNull
            protected Map<K, Collection<V>> createMap() {
                return new WeakHashMap();
            }
        };
    }

    public static <K, V> MultiMap<K, V> create(int initialCapacity, float loadFactor) {
        return new MultiMap<K, V>(initialCapacity, loadFactor);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiMap)) {
            return false;
        }
        return this.myMap.equals(((MultiMap)o).myMap);
    }

    public int hashCode() {
        return this.myMap.hashCode();
    }

    public String toString() {
        return this.myMap.toString();
    }

    public static <K, V> MultiMap<K, V> empty() {
        return EMPTY;
    }

    private static class EmptyMap
    extends MultiMap {
        private EmptyMap() {
        }

        @NotNull
        protected Map createMap() {
            return Collections.emptyMap();
        }
    }
}

