/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.AbstractList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class SortedList<T>
extends AbstractList<T> {
    private final SortedMap<T, List<T>> myMap;
    private final Comparator<T> myComparator;
    private List<T> myDelegate;

    public SortedList(@NotNull Comparator<T> comparator) {
        this.myComparator = comparator;
        this.myMap = new TreeMap<T, List<T>>(comparator);
    }

    @NotNull
    public Comparator<T> getComparator() {
        return this.myComparator;
    }

    @Override
    public void add(int index, T element) {
        this.addToMap(element);
    }

    private void addToMap(T element) {
        SmartList<T> group = (SmartList<T>)this.myMap.get(element);
        if (group == null) {
            group = new SmartList<T>();
            this.myMap.put(element, group);
        }
        group.add(element);
        this.myDelegate = null;
    }

    @Override
    public boolean add(T t) {
        this.addToMap(t);
        return true;
    }

    @Override
    public T remove(int index) {
        T value = this.get(index);
        this.remove(value);
        return value;
    }

    @Override
    public boolean remove(Object value) {
        List group = (List)this.myMap.remove(value);
        if (group == null) {
            return false;
        }
        group.remove(value);
        if (!group.isEmpty()) {
            this.myMap.put(group.get(0), group);
        }
        this.myDelegate = null;
        return true;
    }

    @Override
    public T get(int index) {
        return this.ensureLinearized().get(index);
    }

    @NotNull
    private List<T> ensureLinearized() {
        List<T> delegate = this.myDelegate;
        if (delegate == null) {
            this.myDelegate = delegate = ContainerUtil.concat(this.myMap.values());
        }
        return delegate;
    }

    @Override
    public void clear() {
        this.myMap.clear();
        this.myDelegate = null;
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public int size() {
        return this.ensureLinearized().size();
    }
}

