/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.StripedReentrantLocks;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class StripedLockIntObjectConcurrentHashMap<V>
implements ConcurrentIntObjectMap<V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final StripedReentrantLocks STRIPED_REENTRANT_LOCKS = StripedReentrantLocks.getInstance();
    private final byte lockIndex = (byte)STRIPED_REENTRANT_LOCKS.allocateLockIndex();
    protected volatile int count;
    protected int modCount;
    protected volatile IntHashEntry[] table;

    public StripedLockIntObjectConcurrentHashMap(int initialCapacity, float loadFactor) {
        int cap = StripedLockIntObjectConcurrentHashMap.getInitCap(initialCapacity, loadFactor);
        this.setTable(new IntHashEntry[cap]);
    }

    private static int getInitCap(int initialCapacity, float loadFactor) {
        int cap;
        if (loadFactor <= 0.0f || initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        for (cap = 1; cap < initialCapacity; cap <<= 1) {
        }
        return cap;
    }

    public StripedLockIntObjectConcurrentHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public StripedLockIntObjectConcurrentHashMap() {
        this(16, 0.75f);
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public V put(int key, @NotNull V value) {
        return this.put(key, value, false);
    }

    @Override
    public V putIfAbsent(int key, @NotNull V value) {
        return this.put(key, value, true);
    }

    @Override
    public V remove(int key) {
        return this.doRemove(key, null);
    }

    @Override
    public boolean remove(int key, @NotNull V value) {
        return this.doRemove(key, value) != null;
    }

    @Override
    @NotNull
    public V cacheOrGet(int key, @NotNull V value) {
        V prev = this.putIfAbsent(key, value);
        return prev == null ? value : prev;
    }

    @Override
    @NotNull
    public Enumeration<V> elements() {
        return new ValueIterator();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        THashSet result = new THashSet();
        ContainerUtil.addAll(result, this.elements());
        return result;
    }

    @Override
    @NotNull
    public Iterable<ConcurrentIntObjectMap.IntEntry<V>> entries() {
        return new Iterable<ConcurrentIntObjectMap.IntEntry<V>>(){

            @Override
            public Iterator<ConcurrentIntObjectMap.IntEntry<V>> iterator() {
                final HashIterator hashIterator = new HashIterator();
                return new Iterator<ConcurrentIntObjectMap.IntEntry<V>>(){

                    @Override
                    public boolean hasNext() {
                        return hashIterator.hasNext();
                    }

                    @Override
                    public ConcurrentIntObjectMap.IntEntry<V> next() {
                        IntHashEntry ie = hashIterator.nextEntry;
                        hashIterator.nextEntry();
                        return new SimpleEntry(ie.key, ie.value);
                    }

                    @Override
                    public void remove() {
                        hashIterator.remove();
                    }
                };
            }
        };
    }

    private void lock() {
        STRIPED_REENTRANT_LOCKS.lock(this.lockIndex & 0xFF);
    }

    private void unlock() {
        STRIPED_REENTRANT_LOCKS.unlock(this.lockIndex & 0xFF);
    }

    private int threshold() {
        return (int)((float)this.table.length * 0.75f);
    }

    private void setTable(IntHashEntry[] newTable) {
        this.table = newTable;
    }

    private IntHashEntry<V> getFirst(int hash) {
        IntHashEntry[] tab = this.table;
        return tab[hash & tab.length - 1];
    }

    @Override
    public V get(int key) {
        if (this.count != 0) {
            IntHashEntry<V> e = this.getFirst(key);
            while (e != null) {
                if (key == e.key) {
                    return e.value;
                }
                e = e.next;
            }
        }
        return null;
    }

    @Override
    public boolean containsKey(int key) {
        if (this.count != 0) {
            IntHashEntry<V> e = this.getFirst(key);
            while (e != null) {
                if (key == e.key) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    @Override
    public boolean containsValue(@NotNull V value) {
        if (this.count != 0) {
            ValueIterator valueIterator = new ValueIterator();
            while (valueIterator.hasNext()) {
                Object next = valueIterator.next();
                if (!Comparing.equal(next, value)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(int key, @NotNull V oldValue, @NotNull V newValue) {
        this.lock();
        try {
            IntHashEntry<V> e = this.getFirst(key);
            while (e != null && key != e.key) {
                e = e.next;
            }
            boolean replaced = false;
            if (e != null && oldValue.equals(e.value)) {
                replaced = true;
                e.value = newValue;
            }
            boolean bl = replaced;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected V put(int key, @NotNull V value, boolean onlyIfAbsent) {
        this.lock();
        try {
            V oldValue;
            IntHashEntry first;
            int c = this.count;
            if (c++ > this.threshold()) {
                this.rehash();
            }
            IntHashEntry[] tab = this.table;
            int index = key & tab.length - 1;
            IntHashEntry e = first = tab[index];
            while (e != null && key != e.key) {
                e = e.next;
            }
            if (e != null) {
                oldValue = e.value;
                if (!onlyIfAbsent) {
                    e.value = value;
                }
            } else {
                oldValue = null;
                ++this.modCount;
                tab[index] = new IntHashEntry(key, first, value);
                this.count = c;
            }
            V v = oldValue;
            return v;
        }
        finally {
            this.unlock();
        }
    }

    private void rehash() {
        IntHashEntry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity >= 0x40000000) {
            return;
        }
        IntHashEntry[] newTable = new IntHashEntry[oldCapacity << 1];
        int sizeMask = newTable.length - 1;
        for (IntHashEntry intHashEntry : oldTable) {
            int k;
            if (intHashEntry == null) continue;
            IntHashEntry next = intHashEntry.next;
            int idx = intHashEntry.key & sizeMask;
            if (next == null) {
                newTable[idx] = intHashEntry;
                continue;
            }
            IntHashEntry lastRun = intHashEntry;
            int lastIdx = idx;
            IntHashEntry last = next;
            while (last != null) {
                k = last.key & sizeMask;
                if (k != lastIdx) {
                    lastIdx = k;
                    lastRun = last;
                }
                last = last.next;
            }
            newTable[lastIdx] = lastRun;
            IntHashEntry p = intHashEntry;
            while (p != lastRun) {
                k = p.key & sizeMask;
                IntHashEntry n = newTable[k];
                newTable[k] = new IntHashEntry(p.key, n, p.value);
                p = p.next;
            }
        }
        this.setTable(newTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected V doRemove(int key, V value) {
        this.lock();
        try {
            IntHashEntry first;
            int c = this.count - 1;
            IntHashEntry[] tab = this.table;
            int index = key & tab.length - 1;
            IntHashEntry e = first = tab[index];
            while (e != null && key != e.key) {
                e = e.next;
            }
            V oldValue = null;
            if (e != null) {
                Object v = e.value;
                if (value == null || value.equals(v)) {
                    oldValue = v;
                    ++this.modCount;
                    IntHashEntry newFirst = e.next;
                    IntHashEntry p = first;
                    while (p != e) {
                        newFirst = new IntHashEntry(p.key, newFirst, p.value);
                        p = p.next;
                    }
                    tab[index] = newFirst;
                    this.count = c;
                }
            }
            V v = oldValue;
            return v;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void clear() {
        if (this.count != 0) {
            this.lock();
            try {
                IntHashEntry[] tab = this.table;
                for (int i = 0; i < tab.length; ++i) {
                    tab[i] = null;
                }
                ++this.modCount;
                this.count = 0;
            }
            finally {
                this.unlock();
            }
        }
    }

    public void putAll(@NotNull StripedLockIntObjectConcurrentHashMap<? extends V> t) {
        for (ConcurrentIntObjectMap.IntEntry<V> e : t.entries()) {
            V value = e.getValue();
            this.put(e.getKey(), value);
        }
    }

    @Override
    @NotNull
    public int[] keys() {
        TIntArrayList keys = new TIntArrayList(this.size());
        for (IntHashEntry entry : this.table) {
            if (entry == null) continue;
            keys.add(entry.key);
        }
        return keys.toNativeArray();
    }

    private static final class IntHashEntry<V> {
        final int key;
        @NotNull
        volatile V value;
        final IntHashEntry<V> next;

        IntHashEntry(int key, IntHashEntry<V> next, @NotNull V value) {
            this.key = key;
            this.next = next;
            this.value = value;
        }
    }

    private static final class SimpleEntry<V>
    implements ConcurrentIntObjectMap.IntEntry<V> {
        private final int key;
        private final V value;

        private SimpleEntry(int key, @NotNull V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int getKey() {
            return this.key;
        }

        @Override
        @NotNull
        public V getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SimpleEntry)) {
                return false;
            }
            SimpleEntry e = (SimpleEntry)o;
            int o2 = e.getKey();
            return this.key == o2 && SimpleEntry.eq(this.value, e.getValue());
        }

        public int hashCode() {
            return this.key ^ this.value.hashCode();
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }

    private final class ValueIterator
    extends HashIterator
    implements Iterator<V>,
    Enumeration<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }

        @Override
        public V nextElement() {
            return this.nextEntry().value;
        }
    }

    private class HashIterator {
        private int nextTableIndex;
        private IntHashEntry<V> nextEntry;
        private IntHashEntry<V> lastReturned;

        private HashIterator() {
            this.nextTableIndex = StripedLockIntObjectConcurrentHashMap.this.table.length - 1;
            this.advance();
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        private void advance() {
            if (this.nextEntry != null && (this.nextEntry = this.nextEntry.next) != null) {
                return;
            }
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = StripedLockIntObjectConcurrentHashMap.this.table[this.nextTableIndex--]) == null) continue;
                return;
            }
        }

        public boolean hasNext() {
            return this.nextEntry != null;
        }

        protected IntHashEntry<V> nextEntry() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            this.advance();
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            StripedLockIntObjectConcurrentHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
        }
    }
}

