/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.RefHashMap;
import com.intellij.util.containers.RefKeyRefValueHashMap;
import com.intellij.util.containers.WeakHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class WeakKeySoftValueHashMap<K, V>
extends RefKeyRefValueHashMap<K, V>
implements Map<K, V> {
    WeakKeySoftValueHashMap() {
        super(new WeakHashMap());
    }

    @Override
    protected RefKeyRefValueHashMap.ValueReference<K, V> createValueReference(@NotNull RefHashMap.Key<K> key, V referent, ReferenceQueue<? super V> q) {
        return new SoftValueReference(key, referent, q);
    }

    private static class SoftValueReference<K, V>
    extends SoftReference<V>
    implements RefKeyRefValueHashMap.ValueReference<K, V> {
        @NotNull
        private final RefHashMap.Key<K> key;

        private SoftValueReference(@NotNull RefHashMap.Key<K> key, V referent, ReferenceQueue<? super V> q) {
            super(referent, q);
            this.key = key;
        }

        @Override
        @NotNull
        public RefHashMap.Key<K> getKey() {
            return this.key;
        }
    }
}

