/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.diff;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.util.diff.IntLCS;
import com.intellij.util.diff.LCSBuilder;
import com.intellij.util.diff.PatienceIntLCS;
import com.intellij.util.diff.Reindexer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Diff {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.diff.Diff");

    @Nullable
    public static Change buildChanges(@NotNull CharSequence before, @NotNull CharSequence after) throws FilesTooBigForDiffException {
        String[] strings1 = LineTokenizer.tokenize(before, false);
        String[] strings2 = LineTokenizer.tokenize(after, false);
        return Diff.buildChanges(strings1, strings2);
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static <T> Change buildChanges(@NotNull T[] objects1, @NotNull T[] objects2) throws FilesTooBigForDiffException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:73)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    public static Change buildChanges(@NotNull int[] array1, @NotNull int[] array2) throws FilesTooBigForDiffException {
        int endCut;
        int startShift = Diff.getStartShift(array1, array2);
        Ref<Change> changeRef = Diff.doBuildChangesFast(array1.length, array2.length, startShift, endCut = Diff.getEndCut(array1, array2, startShift));
        if (changeRef != null) {
            return changeRef.get();
        }
        boolean copyArray = startShift != 0 || endCut != 0;
        int[] ints1 = copyArray ? Arrays.copyOfRange(array1, startShift, array1.length - endCut) : array1;
        int[] ints2 = copyArray ? Arrays.copyOfRange(array2, startShift, array2.length - endCut) : array2;
        return Diff.doBuildChanges(ints1, ints2, new ChangeBuilder(startShift));
    }

    @Nullable
    private static Ref<Change> doBuildChangesFast(int length1, int length2, int startShift, int endCut) {
        int trimmedLength1 = length1 - startShift - endCut;
        int trimmedLength2 = length2 - startShift - endCut;
        if (trimmedLength1 != 0 && trimmedLength2 != 0) {
            return null;
        }
        Change change = trimmedLength1 != 0 || trimmedLength2 != 0 ? new Change(startShift, startShift, trimmedLength1, trimmedLength2, null) : null;
        return new Ref<Change>(change);
    }

    private static Change doBuildChanges(@NotNull int[] ints1, @NotNull int[] ints2, @NotNull ChangeBuilder builder) throws FilesTooBigForDiffException {
        BitSet[] changes;
        Reindexer reindexer = new Reindexer();
        int[][] discarded = reindexer.discardUnique(ints1, ints2);
        if (discarded[0].length == 0 && discarded[1].length == 0) {
            builder.addChange(ints1.length, ints2.length);
            return builder.getFirstChange();
        }
        if (Registry.is("diff.patience.alg")) {
            PatienceIntLCS patienceIntLCS = new PatienceIntLCS(discarded[0], discarded[1]);
            patienceIntLCS.execute();
            changes = patienceIntLCS.getChanges();
        } else {
            try {
                IntLCS intLCS = new IntLCS(discarded[0], discarded[1]);
                intLCS.execute();
                changes = intLCS.getChanges();
            }
            catch (FilesTooBigForDiffException e) {
                PatienceIntLCS patienceIntLCS = new PatienceIntLCS(discarded[0], discarded[1]);
                patienceIntLCS.execute(true);
                changes = patienceIntLCS.getChanges();
                LOG.info("Successful fallback to patience diff");
            }
        }
        reindexer.reindex(changes, builder);
        return builder.getFirstChange();
    }

    private static <T> int getStartShift(@NotNull T[] o1, @NotNull T[] o2) {
        int size = Math.min(o1.length, o2.length);
        int idx = 0;
        for (int i = 0; i < size && o1[i].equals(o2[i]); ++i) {
            ++idx;
        }
        return idx;
    }

    private static <T> int getEndCut(@NotNull T[] o1, @NotNull T[] o2, int startShift) {
        int size = Math.min(o1.length, o2.length) - startShift;
        int idx = 0;
        for (int i = 0; i < size && o1[o1.length - i - 1].equals(o2[o2.length - i - 1]); ++i) {
            ++idx;
        }
        return idx;
    }

    private static int getStartShift(@NotNull int[] o1, @NotNull int[] o2) {
        int size = Math.min(o1.length, o2.length);
        int idx = 0;
        for (int i = 0; i < size && o1[i] == o2[i]; ++i) {
            ++idx;
        }
        return idx;
    }

    private static int getEndCut(@NotNull int[] o1, @NotNull int[] o2, int startShift) {
        int size = Math.min(o1.length, o2.length) - startShift;
        int idx = 0;
        for (int i = 0; i < size && o1[o1.length - i - 1] == o2[o2.length - i - 1]; ++i) {
            ++idx;
        }
        return idx;
    }

    public static int translateLine(@NotNull CharSequence before, @NotNull CharSequence after, int line) throws FilesTooBigForDiffException {
        return Diff.translateLine(before, after, line, false);
    }

    public static int translateLine(@NotNull CharSequence before, @NotNull CharSequence after, int line, boolean approximate) throws FilesTooBigForDiffException {
        String[] strings1 = LineTokenizer.tokenize(before, false);
        String[] strings2 = LineTokenizer.tokenize(after, false);
        if (approximate) {
            strings1 = Diff.trim(strings1);
            strings2 = Diff.trim(strings2);
        }
        Change change = Diff.buildChanges(strings1, strings2);
        return Diff.translateLine(change, line, approximate);
    }

    @NotNull
    private static String[] trim(@NotNull String[] lines) {
        return ContainerUtil.map2Array(lines, String.class, new Function<String, String>(){

            @Override
            public String fun(String s) {
                return s.trim();
            }
        });
    }

    public static int translateLine(@Nullable Change change, int line) {
        return Diff.translateLine(change, line, false);
    }

    public static int translateLine(@Nullable Change change, int line, boolean approximate) {
        int result = line;
        Change currentChange = change;
        while (currentChange != null && line >= currentChange.line0) {
            if (line >= currentChange.line0 + currentChange.deleted) {
                result += currentChange.inserted - currentChange.deleted;
            } else {
                return approximate ? currentChange.line1 : -1;
            }
            currentChange = currentChange.link;
        }
        return result;
    }

    public static class ChangeBuilder
    implements LCSBuilder {
        private int myIndex1 = 0;
        private int myIndex2 = 0;
        private Change myFirstChange;
        private Change myLastChange;

        public ChangeBuilder(int startShift) {
            this.skip(startShift, startShift);
        }

        @Override
        public void addChange(int first, int second) {
            Change change = new Change(this.myIndex1, this.myIndex2, first, second, null);
            if (this.myLastChange != null) {
                this.myLastChange.link = change;
            } else {
                this.myFirstChange = change;
            }
            this.myLastChange = change;
            this.skip(first, second);
        }

        private void skip(int first, int second) {
            this.myIndex1 += first;
            this.myIndex2 += second;
        }

        @Override
        public void addEqual(int length) {
            this.skip(length, length);
        }

        public Change getFirstChange() {
            return this.myFirstChange;
        }
    }

    public static class Change {
        public Change link;
        public final int inserted;
        public final int deleted;
        public final int line0;
        public final int line1;

        public Change(int line0, int line1, int deleted, int inserted, @Nullable Change old) {
            this.line0 = line0;
            this.line1 = line1;
            this.inserted = inserted;
            this.deleted = deleted;
            this.link = old;
        }

        @NonNls
        public String toString() {
            return "change[inserted=" + this.inserted + ", deleted=" + this.deleted + ", line0=" + this.line0 + ", line1=" + this.line1 + "]";
        }

        public ArrayList<Change> toList() {
            ArrayList<Change> result = new ArrayList<Change>();
            Change current = this;
            while (current != null) {
                result.add(current);
                current = current.link;
            }
            return result;
        }
    }
}

