/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public class EmptyInputDataDiffBuilder<Key, Value>
extends InputDataDiffBuilder<Key, Value> {
    public EmptyInputDataDiffBuilder(int inputId) {
        super(inputId);
    }

    @Override
    public void differentiate(@NotNull Map<Key, Value> newData, @NotNull KeyValueUpdateProcessor<Key, Value> addProcessor, @NotNull KeyValueUpdateProcessor<Key, Value> updateProcessor, @NotNull RemovedKeyProcessor<Key> removeProcessor) throws StorageException {
        EmptyInputDataDiffBuilder.processKeys(newData, addProcessor, this.myInputId);
    }

    static <Key, Value> void processKeys(@NotNull Map<Key, Value> currentData, final @NotNull KeyValueUpdateProcessor<Key, Value> processor, final int inputId) throws StorageException {
        if (currentData instanceof THashMap) {
            final StorageException[] exception = new StorageException[]{null};
            ((THashMap)currentData).forEachEntry(new TObjectObjectProcedure<Key, Value>(){

                public boolean execute(Key k, Value v) {
                    try {
                        processor.process(k, v, inputId);
                    }
                    catch (StorageException e) {
                        exception[0] = e;
                        return false;
                    }
                    return true;
                }
            });
            if (exception[0] != null) {
                throw exception[0];
            }
        } else {
            for (Map.Entry<Key, Value> entry : currentData.entrySet()) {
                processor.process(entry.getKey(), entry.getValue(), inputId);
            }
        }
    }
}

