/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.impl.AbstractForwardIndex;
import com.intellij.util.indexing.impl.CollectionInputDataDiffBuilder;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.PersistentHashMap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class MapBasedForwardIndex<Key, Value>
extends AbstractForwardIndex<Key, Value> {
    @NotNull
    private volatile PersistentHashMap<Integer, Collection<Key>> myInputsIndex = this.createMap();

    protected MapBasedForwardIndex(IndexExtension<Key, Value, ?> indexExtension) throws IOException {
        super(indexExtension);
    }

    @NotNull
    public abstract PersistentHashMap<Integer, Collection<Key>> createMap() throws IOException;

    @Override
    @NotNull
    public InputDataDiffBuilder<Key, Value> getDiffBuilder(int inputId) throws IOException {
        return new CollectionInputDataDiffBuilder(inputId, this.myInputsIndex.get(inputId));
    }

    @NotNull
    public PersistentHashMap<Integer, Collection<Key>> getInputsIndex() {
        return this.myInputsIndex;
    }

    @Override
    public void putInputData(int inputId, @NotNull Map<Key, Value> data) throws IOException {
        this.putData(inputId, data.keySet());
    }

    public void putData(int inputId, Collection<Key> keyCollection) throws IOException {
        if (keyCollection.size() > 0) {
            this.myInputsIndex.put(inputId, keyCollection);
        } else {
            this.myInputsIndex.remove(inputId);
        }
    }

    @Override
    public void flush() {
        if (this.myInputsIndex.isDirty()) {
            this.myInputsIndex.force();
        }
    }

    @Override
    public void close() throws IOException {
        this.myInputsIndex.close();
    }

    @Override
    public void clear() throws IOException {
        File baseFile = this.myInputsIndex.getBaseFile();
        try {
            this.myInputsIndex.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (baseFile != null) {
            IOUtil.deleteAllFilesStartingWith(baseFile);
        }
        this.myInputsIndex = this.createMap();
    }
}

