/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class UpdateData<Key, Value> {
    protected final Map<Key, Value> myNewData;
    protected final ThrowableComputable<InputDataDiffBuilder<Key, Value>, IOException> myCurrentDataEvaluator;
    private final ID<Key, Value> myIndexId;
    private final ThrowableRunnable<IOException> myForwardIndexUpdate;

    public UpdateData(@NotNull Map<Key, Value> newData, @NotNull ThrowableComputable<InputDataDiffBuilder<Key, Value>, IOException> currentDataEvaluator, @NotNull ID<Key, Value> indexId, @Nullable ThrowableRunnable<IOException> forwardIndexUpdate) {
        this.myNewData = newData;
        this.myCurrentDataEvaluator = currentDataEvaluator;
        this.myIndexId = indexId;
        this.myForwardIndexUpdate = forwardIndexUpdate;
    }

    public void iterateKeys(KeyValueUpdateProcessor<Key, Value> addProcessor, KeyValueUpdateProcessor<Key, Value> updateProcessor, RemovedKeyProcessor<Key> removeProcessor) throws StorageException {
        InputDataDiffBuilder<Key, Value> currentData;
        try {
            currentData = this.getCurrentDataEvaluator().compute();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        currentData.differentiate(this.myNewData, addProcessor, updateProcessor, removeProcessor);
    }

    protected ThrowableComputable<InputDataDiffBuilder<Key, Value>, IOException> getCurrentDataEvaluator() {
        return this.myCurrentDataEvaluator;
    }

    protected Map<Key, Value> getNewData() {
        return this.myNewData;
    }

    public ID<Key, Value> getIndexId() {
        return this.myIndexId;
    }

    public void updateForwardIndex() throws IOException {
        if (this.myForwardIndexUpdate != null) {
            this.myForwardIndexUpdate.run();
        }
    }

    public String toString() {
        return this.myIndexId + "," + this.getClass().getName();
    }
}

