/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

public abstract class BaseDataReader {
    private static final Logger LOG = Logger.getInstance(BaseDataReader.class);
    protected final SleepingPolicy mySleepingPolicy;
    protected final Object mySleepMonitor = new Object();
    protected volatile boolean isStopped;
    private Future<?> myFinishedFuture;

    public BaseDataReader(SleepingPolicy sleepingPolicy) {
        this.mySleepingPolicy = sleepingPolicy != null ? sleepingPolicy : SleepingPolicy.SIMPLE;
    }

    @Deprecated
    protected void start() {
        this.start("");
    }

    protected void start(final @NotNull String presentableName) {
        if (StringUtil.isEmptyOrSpaces(presentableName)) {
            LOG.warn(new Throwable("Must provide not-empty presentable name"));
        }
        if (this.myFinishedFuture == null) {
            this.myFinishedFuture = this.executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    String oldThreadName = Thread.currentThread().getName();
                    if (!StringUtil.isEmptyOrSpaces(presentableName)) {
                        Thread.currentThread().setName("BaseDataReader: " + presentableName);
                    }
                    try {
                        BaseDataReader.this.doRun();
                    }
                    finally {
                        Thread.currentThread().setName(oldThreadName);
                    }
                }
            });
        }
    }

    protected boolean readAvailable() throws IOException {
        return this.mySleepingPolicy == SleepingPolicy.BLOCKING ? this.readAvailableBlocking() : this.readAvailableNonBlocking();
    }

    protected boolean readAvailableNonBlocking() throws IOException {
        throw new UnsupportedOperationException();
    }

    protected boolean readAvailableBlocking() throws IOException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected abstract Future<?> executeOnPooledThread(@NotNull Runnable var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doRun() {
        try {
            boolean stopSignalled = false;
            while (true) {
                boolean read = this.readAvailable();
                if (stopSignalled) return;
                if (this.mySleepingPolicy == SleepingPolicy.BLOCKING) {
                    return;
                }
                stopSignalled = this.isStopped;
                if (stopSignalled) continue;
                Object object = this.mySleepMonitor;
                synchronized (object) {
                    this.mySleepMonitor.wait(this.mySleepingPolicy.getTimeToSleep(read));
                }
            }
        }
        catch (IOException e) {
            LOG.info(e);
            return;
        }
        catch (Exception e) {
            LOG.error(e);
            return;
        }
        finally {
            try {
                this.close();
            }
            catch (IOException e) {
                LOG.error("Can't close stream in thread " + Thread.currentThread().getName(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeReading() {
        Object object = this.mySleepMonitor;
        synchronized (object) {
            this.mySleepMonitor.notifyAll();
        }
    }

    protected abstract void close() throws IOException;

    public void stop() {
        this.isStopped = true;
        this.resumeReading();
    }

    public void waitFor() throws InterruptedException {
        try {
            this.myFinishedFuture.get();
        }
        catch (ExecutionException e) {
            LOG.error(e);
        }
    }

    public void waitFor(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        try {
            this.myFinishedFuture.get(timeout, unit);
        }
        catch (ExecutionException e) {
            LOG.error(e);
        }
    }

    public static class AdaptiveSleepingPolicy
    implements SleepingPolicy {
        private static final int maxSleepTimeWhenIdle = 200;
        private static final int maxIterationsWithCurrentSleepTime = 50;
        private volatile int myIterationsWithCurrentTime;
        private volatile int myCurrentSleepTime = 5;

        @Override
        public int getTimeToSleep(boolean wasActive) {
            int iterationsWithCurrentTime;
            int currentSleepTime = this.myCurrentSleepTime;
            if (wasActive) {
                currentSleepTime = 1;
            } else if (currentSleepTime == 1) {
                currentSleepTime = 5;
                this.myIterationsWithCurrentTime = 0;
            } else if ((iterationsWithCurrentTime = ++this.myIterationsWithCurrentTime) >= 50) {
                this.myIterationsWithCurrentTime = 0;
                currentSleepTime = Math.min(2 * currentSleepTime, 200);
            }
            this.myCurrentSleepTime = currentSleepTime;
            return currentSleepTime;
        }
    }

    public static interface SleepingPolicy {
        public static final int sleepTimeWhenWasActive = 1;
        public static final int sleepTimeWhenIdle = 5;
        public static final SleepingPolicy SIMPLE = new SleepingPolicy(){

            @Override
            public int getTimeToSleep(boolean wasActive) {
                return wasActive ? 1 : 5;
            }
        };
        public static final SleepingPolicy BLOCKING = new SleepingPolicy(){

            @Override
            public int getTimeToSleep(boolean wasActive) {
                return 50;
            }
        };

        public int getTimeToSleep(boolean var1);
    }
}

