/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.Base64;
import com.intellij.util.ThreeState;
import gnu.trove.TIntArrayList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class URLUtil {
    public static final String SCHEME_SEPARATOR = "://";
    public static final String FILE_PROTOCOL = "file";
    public static final String HTTP_PROTOCOL = "http";
    public static final String JAR_PROTOCOL = "jar";
    public static final String JAR_SEPARATOR = "!/";
    public static final Pattern DATA_URI_PATTERN = Pattern.compile("data:([^,;]+/[^,;]+)(;charset(?:=|:)[^,;]+)?(;base64)?,(.+)");
    public static final Pattern URL_PATTERN = Pattern.compile("\\b(mailto:|(news|(ht|f)tp(s?))://|((?<![\\p{L}0-9_.])(www\\.)))[-A-Za-z0-9+$&@#/%?=~_|!:,.;]*[-A-Za-z0-9+$&@#/%=~_|]");

    private URLUtil() {
    }

    public static boolean canContainUrl(@NotNull String line) {
        return line.contains("mailto:") || line.contains(SCHEME_SEPARATOR) || line.contains("www.");
    }

    @NotNull
    public static InputStream openStream(@NotNull URL url) throws IOException {
        String protocol = url.getProtocol();
        return protocol.equals(JAR_PROTOCOL) ? URLUtil.openJarStream(url) : url.openStream();
    }

    @NotNull
    public static InputStream openResourceStream(@NotNull URL url) throws IOException {
        try {
            return URLUtil.openStream(url);
        }
        catch (FileNotFoundException ex) {
            InputStream resourceStream;
            int pos;
            String protocol = url.getProtocol();
            String file = null;
            if (protocol.equals(FILE_PROTOCOL)) {
                file = url.getFile();
            } else if (protocol.equals(JAR_PROTOCOL) && (pos = url.getFile().indexOf("!")) >= 0) {
                file = url.getFile().substring(pos + 1);
            }
            if (file != null && file.startsWith("/") && (resourceStream = URLUtil.class.getResourceAsStream(file)) != null) {
                return resourceStream;
            }
            throw ex;
        }
    }

    @NotNull
    private static InputStream openJarStream(@NotNull URL url) throws IOException {
        Pair<String, String> paths = URLUtil.splitJarUrl(url.getFile());
        if (paths == null) {
            throw new MalformedURLException(url.getFile());
        }
        final ZipFile zipFile = new ZipFile((String)paths.first);
        ZipEntry zipEntry = zipFile.getEntry((String)paths.second);
        if (zipEntry == null) {
            zipFile.close();
            throw new FileNotFoundException("Entry " + (String)paths.second + " not found in " + (String)paths.first);
        }
        return new FilterInputStream(zipFile.getInputStream(zipEntry)){

            @Override
            public void close() throws IOException {
                super.close();
                zipFile.close();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static ThreeState resourceExists(@NotNull URL url) {
        if (url.getProtocol().equals(FILE_PROTOCOL)) {
            return ThreeState.fromBoolean(URLUtil.urlToFile(url).exists());
        }
        if (url.getProtocol().equals(JAR_PROTOCOL)) {
            ThreeState threeState;
            Pair<String, String> paths = URLUtil.splitJarUrl(url.getFile());
            if (paths == null) {
                return ThreeState.NO;
            }
            if (!new File((String)paths.first).isFile()) {
                return ThreeState.NO;
            }
            ZipFile file = new ZipFile((String)paths.first);
            try {
                threeState = ThreeState.fromBoolean(file.getEntry((String)paths.second) != null);
            }
            catch (Throwable throwable) {
                try {
                    file.close();
                    throw throwable;
                }
                catch (IOException e) {
                    return ThreeState.NO;
                }
            }
            file.close();
            return threeState;
        }
        return ThreeState.UNSURE;
    }

    @Nullable
    public static Pair<String, String> splitJarUrl(@NotNull String url) {
        String jarPath;
        String resourcePath;
        block6: {
            int pivot = url.indexOf(JAR_SEPARATOR);
            if (pivot < 0) {
                return null;
            }
            resourcePath = url.substring(pivot + 2);
            jarPath = url.substring(0, pivot);
            if (StringUtil.startsWithConcatenation(jarPath, JAR_PROTOCOL, ":")) {
                jarPath = jarPath.substring(JAR_PROTOCOL.length() + 1);
            }
            if (jarPath.startsWith(FILE_PROTOCOL)) {
                try {
                    jarPath = URLUtil.urlToFile(new URL(jarPath)).getPath().replace('\\', '/');
                }
                catch (Exception e) {
                    jarPath = jarPath.substring(FILE_PROTOCOL.length());
                    if (jarPath.startsWith(SCHEME_SEPARATOR)) {
                        jarPath = jarPath.substring(SCHEME_SEPARATOR.length());
                    }
                    if (!StringUtil.startsWithChar(jarPath, ':')) break block6;
                    jarPath = jarPath.substring(1);
                }
            }
        }
        return Pair.create(jarPath, resourcePath);
    }

    @NotNull
    public static File urlToFile(@NotNull URL url) {
        try {
            return new File(url.toURI().getSchemeSpecificPart());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("URL='" + url.toString() + "'", e);
        }
    }

    @NotNull
    public static String unescapePercentSequences(@NotNull String s) {
        if (s.indexOf(37) == -1) {
            return s;
        }
        StringBuilder decoded = new StringBuilder();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '%') {
                TIntArrayList bytes = new TIntArrayList();
                while (i + 2 < len && s.charAt(i) == '%') {
                    int d1 = URLUtil.decode(s.charAt(i + 1));
                    int d2 = URLUtil.decode(s.charAt(i + 2));
                    if (d1 == -1 || d2 == -1) break;
                    bytes.add((d1 & 0xF) << 4 | d2 & 0xF);
                    i += 3;
                }
                if (!bytes.isEmpty()) {
                    byte[] bytesArray = new byte[bytes.size()];
                    for (int j = 0; j < bytes.size(); ++j) {
                        bytesArray[j] = (byte)bytes.getQuick(j);
                    }
                    decoded.append(new String(bytesArray, CharsetToolkit.UTF8_CHARSET));
                    continue;
                }
            }
            decoded.append(c);
            ++i;
        }
        return decoded.toString();
    }

    private static int decode(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    public static boolean containsScheme(@NotNull String url) {
        return url.contains(SCHEME_SEPARATOR);
    }

    public static boolean isDataUri(@NotNull String value) {
        return !value.isEmpty() && value.startsWith("data:", value.charAt(0) == '\"' || value.charAt(0) == '\'' ? 1 : 0);
    }

    @Nullable
    public static byte[] getBytesFromDataUri(@NotNull String dataUrl) {
        Matcher matcher = DATA_URI_PATTERN.matcher(StringUtil.unquoteString(dataUrl));
        if (matcher.matches()) {
            try {
                String content = matcher.group(4);
                return ";base64".equalsIgnoreCase(matcher.group(3)) ? Base64.decode(content) : content.getBytes(CharsetToolkit.UTF8_CHARSET);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    @NotNull
    public static String parseHostFromSshUrl(@NotNull String sshUrl) {
        String host = sshUrl;
        int at = host.lastIndexOf(64);
        if (at > 0) {
            host = host.substring(at + 1);
        } else {
            int firstColon = host.indexOf(58);
            if (firstColon > 0) {
                host = host.substring(firstColon + 3);
            }
        }
        int colon = host.indexOf(58);
        if (colon > 0) {
            host = host.substring(0, colon);
        } else {
            int slash = host.indexOf(47);
            if (slash > 0) {
                host = host.substring(0, slash);
            }
        }
        return host;
    }

    @NotNull
    public static URL getJarEntryURL(@NotNull File file, @NotNull String pathInJar) throws MalformedURLException {
        String fileURL = StringUtil.replace(file.toURI().toASCIIString(), "!", "%21");
        return new URL("jar:" + fileURL + JAR_SEPARATOR + StringUtil.trimLeading(pathInJar, '/'));
    }

    @NotNull
    public static String encodeURIComponent(@NotNull String s) {
        try {
            return URLEncoder.encode(s, "UTF-8").replaceAll("\\+", "%20").replaceAll("%21", "!").replaceAll("%27", "'").replaceAll("%28", "(").replaceAll("%29", ")").replaceAll("%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }
}

