/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.keyFMap;

import com.intellij.openapi.util.Key;
import com.intellij.util.ArrayUtil;
import com.intellij.util.keyFMap.ArrayBackedFMap;
import com.intellij.util.keyFMap.KeyFMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import org.jetbrains.annotations.NotNull;

class MapBackedFMap
extends TIntObjectHashMap<Object>
implements KeyFMap {
    private MapBackedFMap(@NotNull MapBackedFMap oldMap, final int exclude) {
        super(oldMap.size());
        oldMap.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<Object>(){

            public boolean execute(int key, Object val) {
                if (key != exclude) {
                    MapBackedFMap.this.put(key, val);
                }
                assert (key >= 0) : key;
                return true;
            }
        });
        assert (this.size() > 8);
    }

    MapBackedFMap(@NotNull int[] keys, int newKey, @NotNull Object[] values, @NotNull Object newValue) {
        super(keys.length + 1);
        for (int i = 0; i < keys.length; ++i) {
            int key = keys[i];
            Object value = values[i];
            this.put(key, value);
            assert (key >= 0) : key;
        }
        this.put(newKey, newValue);
        assert (newKey >= 0) : newKey;
        assert (this.size() > 8);
    }

    @Override
    @NotNull
    public <V> KeyFMap plus(@NotNull Key<V> key, @NotNull V value) {
        int keyCode = key.hashCode();
        assert (keyCode >= 0) : key;
        Object oldValue = this.get(keyCode);
        if (value == oldValue) {
            return this;
        }
        MapBackedFMap newMap = new MapBackedFMap(this, -1);
        newMap.put(keyCode, value);
        return newMap;
    }

    @Override
    @NotNull
    public KeyFMap minus(@NotNull Key<?> key) {
        int oldSize = this.size();
        int keyCode = key.hashCode();
        if (!this.containsKey(keyCode)) {
            return this;
        }
        if (oldSize == 9) {
            int[] keys = this.keys();
            Object[] values = this.getValues();
            int i = ArrayUtil.indexOf(keys, keyCode);
            keys = ArrayUtil.remove(keys, i);
            values = ArrayUtil.remove(values, i);
            return new ArrayBackedFMap(keys, values);
        }
        return new MapBackedFMap(this, keyCode);
    }

    @Override
    public <V> V get(@NotNull Key<V> key) {
        return (V)this.get(key.hashCode());
    }

    @Override
    @NotNull
    public Key[] getKeys() {
        return ArrayBackedFMap.getKeysByIndices(this.keys());
    }

    @Override
    public String toString() {
        final StringBuilder s = new StringBuilder();
        this.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<Object>(){

            public boolean execute(int key, Object value) {
                s.append(s.length() == 0 ? "" : ", ").append(Key.getKeyByIndex(key)).append(" -> ").append(value);
                return true;
            }
        });
        return "[" + s.toString() + "]";
    }
}

