/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.lang.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MemoryResource
extends Resource {
    private final URL myUrl;
    private final byte[] myContent;
    private final Map<Resource.Attribute, String> myAttributes;

    private MemoryResource(URL url, byte[] content, Map<Resource.Attribute, String> attributes) {
        this.myUrl = url;
        this.myContent = content;
        this.myAttributes = attributes;
    }

    @Override
    public URL getURL() {
        return this.myUrl;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new UnsyncByteArrayInputStream(this.myContent);
    }

    @Override
    public byte[] getBytes() throws IOException {
        return this.myContent;
    }

    @Override
    public String getValue(Resource.Attribute key) {
        return this.myAttributes != null ? this.myAttributes.get((Object)key) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static MemoryResource load(URL baseUrl, @NotNull ZipFile zipFile, @NotNull ZipEntry entry, @Nullable Map<Resource.Attribute, String> attributes) throws IOException {
        String name = entry.getName();
        URL url = new URL(baseUrl, name);
        byte[] content = ArrayUtil.EMPTY_BYTE_ARRAY;
        InputStream stream = zipFile.getInputStream(entry);
        if (stream != null) {
            try {
                content = FileUtil.loadBytes(stream, (int)entry.getSize());
            }
            finally {
                stream.close();
            }
        }
        return new MemoryResource(url, content, attributes);
    }
}

