/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SemVer
implements Comparable<SemVer> {
    public static final SemVer UNKNOWN = new SemVer("?", 0, 0, 0);
    private final String myRawVersion;
    private final int myMajor;
    private final int myMinor;
    private final int myPatch;

    public SemVer(@NotNull String rawVersion, int major, int minor, int patch) {
        this.myRawVersion = rawVersion;
        this.myMajor = major;
        this.myMinor = minor;
        this.myPatch = patch;
    }

    @NotNull
    public String getRawVersion() {
        return this.myRawVersion;
    }

    public int getMajor() {
        return this.myMajor;
    }

    public int getMinor() {
        return this.myMinor;
    }

    public int getPatch() {
        return this.myPatch;
    }

    @NotNull
    public String getParsedVersion() {
        return this.myMajor + "." + this.myMinor + "." + this.myPatch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SemVer semVer = (SemVer)o;
        if (this.myMajor != semVer.myMajor) {
            return false;
        }
        if (this.myMinor != semVer.myMinor) {
            return false;
        }
        return this.myPatch == semVer.myPatch;
    }

    public int hashCode() {
        int result = this.myMajor;
        result = 31 * result + this.myMinor;
        result = 31 * result + this.myPatch;
        return result;
    }

    public String toString() {
        return this.myRawVersion;
    }

    @Nullable
    public static SemVer parseFromText(@NotNull String text) {
        int majorEndInd = text.indexOf(46);
        if (majorEndInd < 0) {
            return null;
        }
        int major = StringUtil.parseInt(text.substring(0, majorEndInd), -1);
        int minorEndInd = text.indexOf(46, majorEndInd + 1);
        if (minorEndInd < 0) {
            return null;
        }
        int minor = StringUtil.parseInt(text.substring(majorEndInd + 1, minorEndInd), -1);
        int dashInd = text.indexOf(45, minorEndInd + 1);
        String patchStr = dashInd >= 0 ? text.substring(minorEndInd + 1, dashInd) : text.substring(minorEndInd + 1);
        int patch = StringUtil.parseInt(patchStr, -1);
        if (major >= 0 && minor >= 0 && patch >= 0) {
            return new SemVer(text, major, minor, patch);
        }
        return null;
    }

    @NotNull
    public static SemVer parseFromTextNonNullize(@Nullable String text) {
        if (text == null) {
            return UNKNOWN;
        }
        SemVer ver = SemVer.parseFromText(text);
        return ver == null ? UNKNOWN : ver;
    }

    @Override
    public int compareTo(SemVer other) {
        if (this.getMajor() != other.getMajor()) {
            return this.getMajor() - other.getMajor();
        }
        if (this.getMinor() != other.getMinor()) {
            return this.getMinor() - other.getMinor();
        }
        if (this.getPatch() != other.getPatch()) {
            return this.getPatch() - other.getPatch();
        }
        return 0;
    }
}

