/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AccessorBindingWrapper
extends Binding
implements MultiNodeBinding {
    private final Binding myBinding;

    public AccessorBindingWrapper(@NotNull MutableAccessor accessor, @NotNull Binding binding) {
        super(accessor);
        this.myBinding = binding;
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable Object context, @Nullable SerializationFilter filter) {
        Object value = this.myAccessor.read(o);
        if (value == null) {
            throw new XmlSerializationException("Property " + this.myAccessor + " of object " + o + " (" + o.getClass() + ") must not be null");
        }
        return this.myBinding.serialize(value, context, filter);
    }

    @Override
    public Object deserializeUnsafe(Object context, @NotNull Element element) {
        return this.deserialize(context, element);
    }

    @NotNull
    public Object deserialize(@NotNull Object context, @NotNull Element element) {
        Object currentValue = this.myAccessor.read(context);
        if (this.myBinding instanceof BeanBinding && this.myAccessor.isFinal()) {
            ((BeanBinding)this.myBinding).deserializeInto(currentValue, element);
        } else {
            Object deserializedValue = this.myBinding.deserializeUnsafe(currentValue, element);
            if (currentValue != deserializedValue) {
                this.myAccessor.set(context, deserializedValue);
            }
        }
        return context;
    }

    @Override
    @Nullable
    public Object deserializeList(@NotNull Object context, @NotNull List<Element> elements) {
        Object currentValue = this.myAccessor.read(context);
        if (this.myBinding instanceof BeanBinding && this.myAccessor.isFinal()) {
            ((BeanBinding)this.myBinding).deserializeInto(currentValue, elements.get(0));
        } else {
            Object deserializedValue = Binding.deserializeList(this.myBinding, currentValue, elements);
            if (currentValue != deserializedValue) {
                this.myAccessor.set(context, deserializedValue);
            }
        }
        return context;
    }

    @Override
    public boolean isMulti() {
        return this.myBinding instanceof MultiNodeBinding && ((MultiNodeBinding)((Object)this.myBinding)).isMulti();
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        return this.myBinding.isBoundTo(element);
    }
}

