/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.AbstractCollectionBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.XmlSerializerImpl;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CollectionBinding
extends AbstractCollectionBinding {
    public CollectionBinding(@NotNull ParameterizedType type, @Nullable MutableAccessor accessor) {
        super(XmlSerializerImpl.typeToClass(type.getActualTypeArguments()[0]), accessor);
    }

    @Override
    @NotNull
    Object processResult(@NotNull Collection result, @Nullable Object target) {
        if (this.myAccessor == null || target == null) {
            return result;
        }
        assert (target instanceof Collection) : "Wrong target: " + target.getClass() + " in " + this.myAccessor;
        Collection c = (Collection)target;
        c.clear();
        c.addAll(result);
        return target;
    }

    @Override
    @NotNull
    Collection<Object> getIterable(@NotNull Object o) {
        if (this.annotation != null && !this.annotation.sortOrderedSet() && o instanceof LinkedHashSet) {
            return (Collection)o;
        }
        return o instanceof Set ? new TreeSet((Set)o) : (Collection)o;
    }

    @Override
    protected String getCollectionTagName(@Nullable Object target) {
        if (target instanceof Set) {
            return "set";
        }
        if (target instanceof List) {
            return "list";
        }
        return "collection";
    }

    @Override
    protected Collection createCollection(@NotNull String tagName) {
        return tagName.equals("set") ? new HashSet() : super.createCollection(tagName);
    }
}

