/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializerImpl;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TextBinding
extends Binding {
    private final Class<?> valueClass;

    public TextBinding(@NotNull MutableAccessor accessor) {
        super(accessor);
        this.valueClass = XmlSerializerImpl.typeToClass(accessor.getGenericType());
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable Object context, @Nullable SerializationFilter filter) {
        Object value = this.myAccessor.read(o);
        return value == null ? null : new Text(XmlSerializerImpl.convertToString(value));
    }

    @Override
    public Object deserializeUnsafe(Object context, @NotNull Element element) {
        return context;
    }

    void set(@NotNull Object context, @NotNull String value) {
        XmlSerializerImpl.doSet(context, value, this.myAccessor, this.valueClass);
    }
}

