/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.ReflectionUtil;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.MutableAccessor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class XmlSerializerUtil {
    private XmlSerializerUtil() {
    }

    public static <T> void copyBean(@NotNull T from, @NotNull T to) {
        assert (from.getClass().isAssignableFrom(to.getClass())) : "Beans of different classes specified: Cannot assign " + from.getClass() + " to " + to.getClass();
        for (MutableAccessor accessor : BeanBinding.getAccessors(from.getClass())) {
            accessor.set(to, accessor.read(from));
        }
    }

    public static <T> T createCopy(@NotNull T from) {
        try {
            Object to = ReflectionUtil.newInstance(from.getClass());
            XmlSerializerUtil.copyBean(from, to);
            return (T)to;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @NotNull
    public static List<MutableAccessor> getAccessors(@NotNull Class<?> aClass) {
        return BeanBinding.getAccessors(aClass);
    }
}

