/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageView;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCoverageAnnotator
implements CoverageAnnotator {
    private final Project myProject;

    @Nullable
    protected abstract Runnable createRenewRequest(@NotNull CoverageSuitesBundle var1, @NotNull CoverageDataManager var2);

    public BaseCoverageAnnotator(Project project) {
        this.myProject = project;
    }

    @Override
    public void onSuiteChosen(CoverageSuitesBundle newSuite) {
    }

    @Override
    public void renewCoverageData(final @NotNull CoverageSuitesBundle suite, @NotNull CoverageDataManager dataManager) {
        final Runnable request = this.createRenewRequest(suite, dataManager);
        if (request != null) {
            if (this.myProject.isDisposed()) {
                return;
            }
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Loading Coverage Data", false){

                public void run(@NotNull ProgressIndicator indicator) {
                    request.run();
                }

                public void onSuccess() {
                    CoverageView coverageView = CoverageViewManager.getInstance(this.myProject).getToolwindow(suite);
                    if (coverageView != null) {
                        coverageView.updateParentTitle();
                    }
                }
            });
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    public static class DirCoverageInfo
    extends FileCoverageInfo {
        public int totalFilesCount;
        public int coveredFilesCount;
    }

    public static class FileCoverageInfo {
        public int totalLineCount;
        public int coveredLineCount;
    }
}

