/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.JavaCoverageRunner;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.jacoco.agent.rt.RT;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.analysis.ILine;
import org.jacoco.core.analysis.IMethodCoverage;
import org.jacoco.core.data.ExecutionDataReader;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JaCoCoCoverageRunner
extends JavaCoverageRunner {
    private static final Logger LOG = Logger.getInstance((String)("#" + JaCoCoCoverageRunner.class.getName()));

    @Override
    public ProjectData loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite) {
        ProjectData data = new ProjectData();
        try {
            Project project;
            Project project2 = project = baseCoverageSuite instanceof BaseCoverageSuite ? ((BaseCoverageSuite)baseCoverageSuite).getProject() : null;
            if (project != null) {
                JaCoCoCoverageRunner.loadExecutionData(sessionDataFile, data, project);
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return data;
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadExecutionData(@NotNull File sessionDataFile, ProjectData data, @NotNull Project project) throws IOException {
        ExecutionDataStore executionDataStore = new ExecutionDataStore();
        try (FileInputStream fis = null;){
            fis = new FileInputStream(sessionDataFile);
            ExecutionDataReader executionDataReader = new ExecutionDataReader((InputStream)fis);
            executionDataReader.setExecutionDataVisitor((IExecutionDataVisitor)executionDataStore);
            executionDataReader.setSessionInfoVisitor(new ISessionInfoVisitor(){

                public void visitSessionInfo(SessionInfo info) {
                    System.out.println(info.toString());
                }
            });
            while (executionDataReader.read()) {
            }
        }
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(executionDataStore, (ICoverageVisitor)coverageBuilder);
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        for (Module module : modules) {
            CompilerModuleExtension compilerModuleExtension = CompilerModuleExtension.getInstance((Module)module);
            if (compilerModuleExtension == null) continue;
            VirtualFile[] roots = compilerModuleExtension.getOutputRoots(true);
            for (VirtualFile root : roots) {
                analyzer.analyzeAll(VfsUtil.virtualToIoFile((VirtualFile)root));
            }
        }
        for (IClassCoverage classCoverage : coverageBuilder.getClasses()) {
            String className = classCoverage.getName();
            className = className.replace('\\', '.').replace('/', '.');
            ClassData classData = data.getOrCreateClassData(className);
            Collection methods = classCoverage.getMethods();
            LineData[] lines = new LineData[classCoverage.getLastLine() + 1];
            for (IMethodCoverage method : methods) {
                String desc = method.getName() + method.getDesc();
                int firstLine = method.getFirstLine();
                int lastLine = method.getLastLine();
                for (int i = firstLine; i <= lastLine; ++i) {
                    ILine methodLine = method.getLine(i);
                    final int methodLineStatus = methodLine.getStatus();
                    if (methodLineStatus == 0) continue;
                    LineData lineData = new LineData(i, desc){

                        public int getStatus() {
                            switch (methodLineStatus) {
                                case 2: {
                                    return 2;
                                }
                                case 3: {
                                    return 1;
                                }
                            }
                            return 0;
                        }
                    };
                    lineData.setHits(methodLineStatus == 2 || methodLineStatus == 3 ? 1 : 0);
                    lines[i] = lineData;
                }
            }
            classData.setLines(lines);
        }
    }

    @Override
    public void appendCoverageArgument(String sessionDataFilePath, String[] patterns, SimpleJavaParameters javaParameters, boolean collectLineInfo, boolean isSampling) {
        StringBuffer argument = new StringBuffer("-javaagent:");
        String agentPath = PathUtil.getJarPathForClass(RT.class);
        String parentPath = JaCoCoCoverageRunner.handleSpacesInPath(agentPath);
        argument.append(parentPath).append(File.separator).append(new File(agentPath).getName());
        argument.append("=");
        argument.append("destfile=").append(sessionDataFilePath);
        argument.append(",append=false");
        javaParameters.getVMParametersList().add(argument.toString());
    }

    @Override
    public String getPresentableName() {
        return "JaCoCo";
    }

    @Override
    public String getId() {
        return "jacoco";
    }

    @Override
    public String getDataFileExtension() {
        return "exec";
    }

    @Override
    public boolean isCoverageByTestApplicable() {
        return false;
    }
}

