/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.BaseCoverageAnnotator;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleCoverageAnnotator
extends BaseCoverageAnnotator {
    private final Map<String, BaseCoverageAnnotator.FileCoverageInfo> myFileCoverageInfos = new HashMap();
    private final Map<String, BaseCoverageAnnotator.DirCoverageInfo> myTestDirCoverageInfos = new HashMap();
    private final Map<String, BaseCoverageAnnotator.DirCoverageInfo> myDirCoverageInfos = new HashMap();

    public SimpleCoverageAnnotator(Project project) {
        super(project);
    }

    @Override
    public void onSuiteChosen(CoverageSuitesBundle newSuite) {
        super.onSuiteChosen(newSuite);
        this.myFileCoverageInfos.clear();
        this.myTestDirCoverageInfos.clear();
        this.myDirCoverageInfos.clear();
    }

    @Nullable
    protected BaseCoverageAnnotator.DirCoverageInfo getDirCoverageInfo(@NotNull PsiDirectory directory, @NotNull CoverageSuitesBundle currentSuite) {
        VirtualFile dir = directory.getVirtualFile();
        boolean isInTestContent = TestSourcesFilter.isTestSources((VirtualFile)dir, (Project)directory.getProject());
        if (!currentSuite.isTrackTestFolders() && isInTestContent) {
            return null;
        }
        String path = SimpleCoverageAnnotator.normalizeFilePath(dir.getPath());
        return isInTestContent ? this.myTestDirCoverageInfos.get(path) : this.myDirCoverageInfos.get(path);
    }

    @Override
    @Nullable
    public String getDirCoverageInformationString(@NotNull PsiDirectory directory, @NotNull CoverageSuitesBundle currentSuite, @NotNull CoverageDataManager manager) {
        BaseCoverageAnnotator.DirCoverageInfo coverageInfo = this.getDirCoverageInfo(directory, currentSuite);
        if (coverageInfo == null) {
            return null;
        }
        if (manager.isSubCoverageActive()) {
            return coverageInfo.coveredLineCount > 0 ? "covered" : null;
        }
        String filesCoverageInfo = this.getFilesCoverageInformationString(coverageInfo);
        if (filesCoverageInfo != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(filesCoverageInfo);
            String linesCoverageInfo = this.getLinesCoverageInformationString(coverageInfo);
            if (linesCoverageInfo != null) {
                builder.append(", ").append(linesCoverageInfo);
            }
            return builder.toString();
        }
        return null;
    }

    @Deprecated
    public static String getFilePath(String filePath) {
        return SimpleCoverageAnnotator.normalizeFilePath(filePath);
    }

    @NotNull
    private static String normalizeFilePath(@NotNull String filePath) {
        if (SystemInfo.isWindows) {
            filePath = filePath.toLowerCase();
        }
        return FileUtil.toSystemIndependentName((String)filePath);
    }

    @Override
    @Nullable
    public String getFileCoverageInformationString(@NotNull PsiFile psiFile, @NotNull CoverageSuitesBundle currentSuite, @NotNull CoverageDataManager manager) {
        VirtualFile file = psiFile.getVirtualFile();
        assert (file != null);
        String path = SimpleCoverageAnnotator.normalizeFilePath(file.getPath());
        BaseCoverageAnnotator.FileCoverageInfo coverageInfo = this.myFileCoverageInfos.get(path);
        if (coverageInfo == null) {
            return null;
        }
        if (manager.isSubCoverageActive()) {
            return coverageInfo.coveredLineCount > 0 ? "covered" : null;
        }
        return this.getLinesCoverageInformationString(coverageInfo);
    }

    @Nullable
    protected BaseCoverageAnnotator.FileCoverageInfo collectBaseFileCoverage(@NotNull VirtualFile file, @NotNull Annotator annotator, @NotNull ProjectData projectData, @NotNull Map<String, String> normalizedFiles2Files) {
        String filePath = SimpleCoverageAnnotator.normalizeFilePath(file.getPath());
        ClassData classData = SimpleCoverageAnnotator.getClassData(filePath, projectData, normalizedFiles2Files);
        BaseCoverageAnnotator.FileCoverageInfo info = classData != null ? this.fileInfoForCoveredFile(classData) : this.fillInfoForUncoveredFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
        if (info != null) {
            annotator.annotateFile(filePath, info);
        }
        return info;
    }

    @Nullable
    private static ClassData getClassData(@NotNull String filePath, @NotNull ProjectData data, @NotNull Map<String, String> normalizedFiles2Files) {
        String originalFileName = normalizedFiles2Files.get(filePath);
        if (originalFileName == null) {
            return null;
        }
        return data.getClassData(originalFileName);
    }

    @Nullable
    protected BaseCoverageAnnotator.DirCoverageInfo collectFolderCoverage(@NotNull VirtualFile dir, @NotNull CoverageDataManager dataManager, Annotator annotator, ProjectData projectInfo, boolean trackTestFolders, @NotNull ProjectFileIndex index, @NotNull CoverageEngine coverageEngine, Set<VirtualFile> visitedDirs, @NotNull Map<String, String> normalizedFiles2Files) {
        if (!index.isInContent(dir)) {
            return null;
        }
        if (visitedDirs.contains(dir)) {
            return null;
        }
        if (!this.shouldCollectCoverageInsideLibraryDirs() && (index.isInLibrarySource(dir) || index.isInLibraryClasses(dir))) {
            return null;
        }
        visitedDirs.add(dir);
        boolean isInTestSrcContent = TestSourcesFilter.isTestSources((VirtualFile)dir, (Project)this.getProject());
        if (!trackTestFolders && isInTestSrcContent) {
            return null;
        }
        VirtualFile[] children = (VirtualFile[])dataManager.doInReadActionIfProjectOpen(() -> ((VirtualFile)dir).getChildren());
        if (children == null) {
            return null;
        }
        BaseCoverageAnnotator.DirCoverageInfo dirCoverageInfo = new BaseCoverageAnnotator.DirCoverageInfo();
        for (VirtualFile fileOrDir : children) {
            BaseCoverageAnnotator.FileCoverageInfo fileInfo;
            if (fileOrDir.isDirectory()) {
                BaseCoverageAnnotator.DirCoverageInfo childCoverageInfo = this.collectFolderCoverage(fileOrDir, dataManager, annotator, projectInfo, trackTestFolders, index, coverageEngine, visitedDirs, normalizedFiles2Files);
                if (childCoverageInfo == null) continue;
                dirCoverageInfo.totalFilesCount += childCoverageInfo.totalFilesCount;
                dirCoverageInfo.coveredFilesCount += childCoverageInfo.coveredFilesCount;
                dirCoverageInfo.totalLineCount += childCoverageInfo.totalLineCount;
                dirCoverageInfo.coveredLineCount += childCoverageInfo.coveredLineCount;
                continue;
            }
            if (!coverageEngine.coverageProjectViewStatisticsApplicableTo(fileOrDir) || (fileInfo = this.collectBaseFileCoverage(fileOrDir, annotator, projectInfo, normalizedFiles2Files)) == null) continue;
            dirCoverageInfo.totalLineCount += fileInfo.totalLineCount;
            ++dirCoverageInfo.totalFilesCount;
            if (fileInfo.coveredLineCount <= 0) continue;
            ++dirCoverageInfo.coveredFilesCount;
            dirCoverageInfo.coveredLineCount += fileInfo.coveredLineCount;
        }
        if (dirCoverageInfo.totalFilesCount == 0) {
            return null;
        }
        String dirPath = SimpleCoverageAnnotator.normalizeFilePath(dir.getPath());
        if (isInTestSrcContent) {
            annotator.annotateTestDirectory(dirPath, dirCoverageInfo);
        } else {
            annotator.annotateSourceDirectory(dirPath, dirCoverageInfo);
        }
        return dirCoverageInfo;
    }

    protected boolean shouldCollectCoverageInsideLibraryDirs() {
        return true;
    }

    public void annotate(@NotNull VirtualFile contentRoot, @NotNull CoverageSuitesBundle suite, @NotNull CoverageDataManager dataManager, @NotNull ProjectData data, Project project, Annotator annotator) {
        if (!contentRoot.isValid()) {
            return;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Set files = data.getClasses().keySet();
        java.util.HashMap normalizedFiles2Files = ContainerUtil.newHashMap();
        for (String file : files) {
            normalizedFiles2Files.put(SimpleCoverageAnnotator.normalizeFilePath(file), file);
        }
        this.collectFolderCoverage(contentRoot, dataManager, annotator, data, suite.isTrackTestFolders(), index, suite.getCoverageEngine(), ContainerUtil.newHashSet(), Collections.unmodifiableMap(normalizedFiles2Files));
    }

    @Override
    @Nullable
    protected Runnable createRenewRequest(@NotNull CoverageSuitesBundle suite, @NotNull CoverageDataManager dataManager) {
        ProjectData data = suite.getCoverageData();
        if (data == null) {
            return null;
        }
        return () -> {
            Project project = this.getProject();
            ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project);
            VirtualFile[] modulesContentRoots = (VirtualFile[])dataManager.doInReadActionIfProjectOpen(() -> rootManager.getContentRoots());
            if (modulesContentRoots == null) {
                return;
            }
            for (VirtualFile root : modulesContentRoots) {
                this.annotate(root, suite, dataManager, data, project, new Annotator(){

                    @Override
                    public void annotateSourceDirectory(String dirPath, BaseCoverageAnnotator.DirCoverageInfo info) {
                        SimpleCoverageAnnotator.this.myDirCoverageInfos.put(dirPath, info);
                    }

                    @Override
                    public void annotateTestDirectory(String dirPath, BaseCoverageAnnotator.DirCoverageInfo info) {
                        SimpleCoverageAnnotator.this.myTestDirCoverageInfos.put(dirPath, info);
                    }

                    @Override
                    public void annotateFile(@NotNull String filePath, @NotNull BaseCoverageAnnotator.FileCoverageInfo info) {
                        SimpleCoverageAnnotator.this.myFileCoverageInfos.put(filePath, info);
                    }
                });
            }
            dataManager.triggerPresentationUpdate();
        };
    }

    @Nullable
    protected String getLinesCoverageInformationString(@NotNull BaseCoverageAnnotator.FileCoverageInfo info) {
        return SimpleCoverageAnnotator.calcCoveragePercentage(info) + "% lines covered";
    }

    protected static int calcCoveragePercentage(BaseCoverageAnnotator.FileCoverageInfo info) {
        return SimpleCoverageAnnotator.calcPercent(info.coveredLineCount, info.totalLineCount);
    }

    private static int calcPercent(int covered, int total) {
        return total != 0 ? (int)((double)covered / (double)total * 100.0) : 100;
    }

    @Nullable
    protected String getFilesCoverageInformationString(@NotNull BaseCoverageAnnotator.DirCoverageInfo info) {
        return SimpleCoverageAnnotator.calcPercent(info.coveredFilesCount, info.totalFilesCount) + "% files";
    }

    @Nullable
    private BaseCoverageAnnotator.FileCoverageInfo fileInfoForCoveredFile(@NotNull ClassData classData) {
        Object[] lines = classData.getLines();
        int count = lines.length - 1;
        if (count == 0) {
            return null;
        }
        BaseCoverageAnnotator.FileCoverageInfo info = new BaseCoverageAnnotator.FileCoverageInfo();
        info.coveredLineCount = 0;
        info.totalLineCount = 0;
        for (int i = 1; i <= count; ++i) {
            LineData lineData = classData.getLineData(i);
            this.processLineData(info, lineData);
        }
        return info;
    }

    protected void processLineData(@NotNull BaseCoverageAnnotator.FileCoverageInfo info, @Nullable LineData lineData) {
        if (lineData == null) {
            return;
        }
        int status = lineData.getStatus();
        if (status != 0) {
            ++info.coveredLineCount;
        }
        ++info.totalLineCount;
    }

    @Nullable
    protected BaseCoverageAnnotator.FileCoverageInfo fillInfoForUncoveredFile(@NotNull File file) {
        return null;
    }

    private static interface Annotator {
        public void annotateSourceDirectory(String var1, BaseCoverageAnnotator.DirCoverageInfo var2);

        public void annotateTestDirectory(String var1, BaseCoverageAnnotator.DirCoverageInfo var2);

        public void annotateFile(@NotNull String var1, @NotNull BaseCoverageAnnotator.FileCoverageInfo var2);
    }
}

