/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.actions;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.ImplementationViewComponent;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.PanelWithText;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.ui.popup.NotLookupOrSearchCondition;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.HashSet;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class ShowCoveringTestsAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)("#" + ShowCoveringTestsAction.class.getName()));
    private final String myClassFQName;
    private final LineData myLineData;

    public ShowCoveringTestsAction(String classFQName, LineData lineData) {
        super("Show tests covering line", "Show tests covering line", PlatformIcons.TEST_SOURCE_FOLDER);
        this.myClassFQName = classFQName;
        this.myLineData = lineData;
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext context = e.getDataContext();
        Project project = e.getProject();
        LOG.assertTrue(project != null);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        LOG.assertTrue(editor != null);
        CoverageSuitesBundle currentSuite = CoverageDataManager.getInstance(project).getCurrentSuitesBundle();
        LOG.assertTrue(currentSuite != null);
        File[] traceFiles = ShowCoveringTestsAction.getTraceFiles(project);
        HashSet tests = new HashSet();
        Runnable runnable = () -> this.lambda$actionPerformed$0(traceFiles, (Set)tests);
        if (ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, "Extract information about tests", false, project)) {
            ComponentPopupBuilder popupBuilder;
            ImplementationViewComponent component;
            Object[] testNames = ArrayUtil.toStringArray((Collection)tests);
            Arrays.sort(testNames);
            if (testNames.length == 0) {
                HintManager.getInstance().showErrorHint(editor, "Failed to load covered tests");
                return;
            }
            List<PsiElement> elements = currentSuite.getCoverageEngine().findTestsByNames((String[])testNames, project);
            String title = "Tests covering line " + this.myClassFQName + ":" + this.myLineData.getLineNumber();
            if (!elements.isEmpty()) {
                component = new ImplementationViewComponent(PsiUtilCore.toPsiElementArray(elements), 0);
                popupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)component, component.getPreferredFocusableComponent()).setDimensionServiceKey(project, "ShowTestsPopup", false).setCouldPin(popup -> {
                    component.showInUsageView();
                    popup.cancel();
                    return false;
                });
            } else {
                component = null;
                PanelWithText panel = new PanelWithText("Following test" + (testNames.length > 1 ? "s" : "") + " could not be found: " + StringUtil.join((String[])testNames, (String)"<br/>").replace("_", "."));
                popupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel, null);
            }
            JBPopup popup2 = popupBuilder.setRequestFocusCondition(project, (Condition)NotLookupOrSearchCondition.INSTANCE).setProject(project).setResizable(true).setMovable(true).setTitle(title).createPopup();
            popup2.showInBestPositionFor(editor);
            if (component != null) {
                component.setHint(popup2, title);
            }
        }
    }

    private void extractTests(File traceFile, DataInputStream in, Set<String> tests) throws IOException {
        long traceSize = in.readInt();
        int i = 0;
        while ((long)i < traceSize) {
            String className = in.readUTF();
            int linesSize = in.readInt();
            for (int l = 0; l < linesSize; ++l) {
                int line = in.readInt();
                if (!Comparing.strEqual((String)className, (String)this.myClassFQName) || this.myLineData.getLineNumber() != line) continue;
                tests.add(FileUtil.getNameWithoutExtension((File)traceFile));
                return;
            }
            ++i;
        }
    }

    public void update(AnActionEvent e) {
        File[] files;
        Project project;
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(false);
        if (this.myLineData != null && this.myLineData.getStatus() != 0 && (project = e.getProject()) != null && (files = ShowCoveringTestsAction.getTraceFiles(project)) != null && files.length > 0) {
            presentation.setEnabled(CoverageDataManager.getInstance(project).getCurrentSuitesBundle().isCoverageByTestEnabled());
        }
    }

    @Nullable
    private static File[] getTraceFiles(Project project) {
        CoverageSuitesBundle currentSuite = CoverageDataManager.getInstance(project).getCurrentSuitesBundle();
        if (currentSuite == null) {
            return null;
        }
        ArrayList files = new ArrayList();
        for (CoverageSuite coverageSuite : currentSuite.getSuites()) {
            String filePath = coverageSuite.getCoverageDataFileName();
            String dirName = FileUtil.getNameWithoutExtension((String)new File(filePath).getName());
            File parentDir = new File(filePath).getParentFile();
            File tracesDir = new File(parentDir, dirName);
            File[] suiteFiles = tracesDir.listFiles();
            if (suiteFiles == null) continue;
            Collections.addAll(files, suiteFiles);
        }
        return files.isEmpty() ? null : files.toArray(new File[files.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$actionPerformed$0(File[] traceFiles, Set tests) {
        for (File traceFile : traceFiles) {
            FilterInputStream in = null;
            try {
                in = new DataInputStream(new FileInputStream(traceFile));
                this.extractTests(traceFile, (DataInputStream)in, tests);
            }
            catch (Exception ex) {
                LOG.error(traceFile.getName(), (Throwable)ex);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    LOG.error((Throwable)ex);
                }
            }
        }
    }
}

