/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnalysisScope {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.analysis.AnalysisScope");
    public static final int PROJECT = 1;
    public static final int DIRECTORY = 2;
    public static final int FILE = 3;
    public static final int MODULE = 4;
    public static final int INVALID = 6;
    public static final int MODULES = 7;
    public static final int CUSTOM = 8;
    public static final int VIRTUAL_FILES = 9;
    public static final int UNCOMMITTED_FILES = 10;
    @NotNull
    private final Project myProject;
    protected List<Module> myModules;
    protected Module myModule;
    protected PsiElement myElement;
    private final SearchScope myScope;
    private boolean mySearchInLibraries;
    private GlobalSearchScope myFilter;
    @Type
    protected int myType;
    private final Set<VirtualFile> myVFiles;
    Set<VirtualFile> myFilesSet;
    private boolean myIncludeTestSource = true;

    public AnalysisScope(@NotNull Project project) {
        this.myProject = project;
        this.myElement = null;
        this.myModules = null;
        this.myModule = null;
        this.myScope = null;
        this.myType = 1;
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull Module module) {
        this.myProject = module.getProject();
        this.myElement = null;
        this.myModules = null;
        this.myScope = null;
        this.myModule = module;
        this.myType = 4;
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull Module[] modules) {
        this.myModules = Arrays.asList(modules);
        this.myModule = null;
        this.myProject = modules[0].getProject();
        this.myElement = null;
        this.myScope = null;
        this.myType = 7;
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull PsiDirectory psiDirectory) {
        this.myProject = psiDirectory.getProject();
        this.myModules = null;
        this.myModule = null;
        this.myScope = null;
        this.myElement = psiDirectory;
        this.myType = 2;
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull PsiFile psiFile) {
        this.myProject = psiFile.getProject();
        this.myElement = psiFile;
        this.myModule = null;
        this.myModules = null;
        this.myScope = null;
        this.myType = 3;
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull SearchScope scope, @NotNull Project project) {
        this.myProject = project;
        this.myElement = null;
        this.myModule = null;
        this.myModules = null;
        this.myScope = scope;
        this.myType = 8;
        this.mySearchInLibraries = scope instanceof GlobalSearchScope && ((GlobalSearchScope)scope).isSearchInLibraries();
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull Project project, @NotNull Collection<VirtualFile> virtualFiles) {
        this.myProject = project;
        this.myElement = null;
        this.myModule = null;
        this.myModules = null;
        this.myScope = null;
        this.myVFiles = new HashSet<VirtualFile>(virtualFiles);
        this.myType = 9;
    }

    public void setSearchInLibraries(boolean searchInLibraries) {
        this.mySearchInLibraries = searchInLibraries;
    }

    public void setIncludeTestSource(boolean includeTestSource) {
        this.myIncludeTestSource = includeTestSource;
    }

    @NotNull
    PsiElementVisitor createFileSearcher() {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setText(AnalysisScopeBundle.message("scanning.scope.progress.title", new Object[0]));
        }
        return new PsiElementVisitor(){

            @Override
            public void visitFile(@NotNull PsiFile file) {
                if (AnalysisScope.this.mySearchInLibraries || !(file instanceof PsiCompiledElement)) {
                    VirtualFile virtualFile2 = file.getVirtualFile();
                    if (virtualFile2 == null) {
                        return;
                    }
                    if (AnalysisScope.this.isFiltered(virtualFile2)) {
                        return;
                    }
                    if (!AnalysisScope.shouldHighlightFile(file)) {
                        return;
                    }
                    AnalysisScope.this.myFilesSet.add(virtualFile2);
                }
            }
        };
    }

    private boolean isFiltered(VirtualFile virtualFile2) {
        if (this.myFilter != null && !this.myFilter.contains(virtualFile2)) {
            return true;
        }
        return !this.myIncludeTestSource && TestSourcesFilter.isTestSources(virtualFile2, this.myProject);
    }

    @NotNull
    private FileIndex getFileIndex() {
        FileIndex fileIndex = this.myModule != null ? ModuleRootManager.getInstance(this.myModule).getFileIndex() : ProjectRootManager.getInstance(this.myProject).getFileIndex();
        return fileIndex;
    }

    private static String displayProjectRelativePath(@NotNull PsiFileSystemItem item) {
        VirtualFile virtualFile2 = item.getVirtualFile();
        LOG.assertTrue(virtualFile2 != null, (Object)item);
        return ProjectUtilCore.displayUrlRelativeToProject(virtualFile2, virtualFile2.getPresentableUrl(), item.getProject(), true, false);
    }

    public boolean contains(@NotNull PsiElement psiElement) {
        VirtualFile file = psiElement.getContainingFile().getVirtualFile();
        return file != null && this.contains(file);
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (this.myFilesSet == null) {
            if (this.myType == 8 && this.myScope != null) {
                return this.myScope.contains(file);
            }
            if (this.myType == 1) {
                ProjectFileIndex index = ProjectRootManager.getInstance(this.myProject).getFileIndex();
                return index.isInContent(file) && !this.isFiltered(file);
            }
            this.initFilesSet();
        }
        return this.myFilesSet.contains(file);
    }

    protected void initFilesSet() {
        if (this.myType == 3) {
            this.myFilesSet = new HashSet<VirtualFile>(1);
            this.myFilesSet.add(((PsiFileSystemItem)this.myElement).getVirtualFile());
        } else if (this.myType == 2 || this.myType == 1 || this.myType == 7 || this.myType == 4 || this.myType == 8) {
            this.myFilesSet = new THashSet();
            this.accept(this.createFileSearcher(), false);
        } else if (this.myType == 9) {
            this.myFilesSet = new THashSet();
            final ProjectFileIndex fileIndex = ProjectRootManager.getInstance(this.myProject).getFileIndex();
            Iterator<VirtualFile> iterator = this.myVFiles.iterator();
            while (iterator.hasNext()) {
                VirtualFile vFile = iterator.next();
                VfsUtilCore.visitChildrenRecursively(vFile, new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                    @Override
                    @NotNull
                    public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                        boolean ignored = fileIndex.isExcluded(file);
                        if (!ignored && !file.isDirectory()) {
                            AnalysisScope.this.myFilesSet.add(file);
                        }
                        return ignored ? SKIP_CHILDREN : CONTINUE;
                    }
                });
                if (!vFile.isDirectory()) continue;
                iterator.remove();
            }
        }
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        this.accept(visitor, true);
    }

    private void accept(@NotNull PsiElementVisitor visitor, boolean clearResolveCache) {
        boolean needReadAction = !ApplicationManager.getApplication().isReadAccessAllowed();
        PsiManager psiManager = PsiManager.getInstance(this.myProject);
        FileIndex fileIndex = this.getFileIndex();
        this.accept((Processor<VirtualFile>)((Processor)file -> {
            if (file.isDirectory()) {
                return true;
            }
            if (ProjectCoreUtil.isProjectOrWorkspaceFile(file, file.getFileType())) {
                return true;
            }
            if (fileIndex.isInContent((VirtualFile)file) && !this.isFiltered((VirtualFile)file) && !GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(file, this.myProject)) {
                return AnalysisScope.processFile(file, visitor, psiManager, needReadAction, clearResolveCache);
            }
            return true;
        }));
    }

    public boolean accept(@NotNull Processor<VirtualFile> processor) {
        List<Module> modules;
        if (this.myType == 9) {
            if (this.myFilesSet == null) {
                this.initFilesSet();
            }
            for (VirtualFile file : this.myFilesSet) {
                if (this.isFiltered(file) || processor.process((Object)file)) continue;
                return false;
            }
            return true;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance(this.myProject).getFileIndex();
        if (this.myScope instanceof GlobalSearchScope) {
            ContentIterator contentIterator = this.createScopeIterator(processor, this.myScope);
            if (!projectFileIndex.iterateContent(contentIterator)) {
                return false;
            }
            if (this.mySearchInLibraries) {
                VirtualFile[] libraryRoots;
                for (VirtualFile libraryRoot : libraryRoots = LibraryUtil.getLibraryRoots(this.myProject, false, false)) {
                    if (VfsUtilCore.iterateChildrenRecursively(libraryRoot, VirtualFileFilter.ALL, contentIterator)) continue;
                    return false;
                }
            }
            return true;
        }
        if (this.myScope instanceof LocalSearchScope) {
            PsiElement[] psiElements = ((LocalSearchScope)this.myScope).getScope();
            THashSet files = new THashSet();
            for (PsiElement element : psiElements) {
                VirtualFile file = (VirtualFile)ReadAction.compute(() -> PsiUtilCore.getVirtualFile(element));
                if (file == null || !files.add(file) || processor.process((Object)file)) continue;
                return false;
            }
            return true;
        }
        List<Module> list = modules = this.myModule != null ? Collections.singletonList(this.myModule) : this.myModules;
        if (modules != null) {
            for (Module module : modules) {
                ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance(module).getFileIndex();
                if (moduleFileIndex.iterateContent(this.createScopeIterator(processor, null))) continue;
                return false;
            }
            return true;
        }
        if (this.myElement instanceof PsiDirectory) {
            return this.accept((PsiDirectory)this.myElement, processor);
        }
        if (this.myElement != null) {
            VirtualFile file = (VirtualFile)ReadAction.compute(() -> PsiUtilCore.getVirtualFile(this.myElement));
            return file == null || processor.process((Object)file);
        }
        return projectFileIndex.iterateContent(this.createScopeIterator(processor, null));
    }

    @NotNull
    private ContentIterator createScopeIterator(@NotNull Processor<VirtualFile> processor, @Nullable SearchScope searchScope) {
        return fileOrDir -> {
            boolean isInScope = (Boolean)ReadAction.compute(() -> {
                if (this.isFiltered(fileOrDir)) {
                    return false;
                }
                if (GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(fileOrDir, this.myProject)) {
                    return false;
                }
                return searchScope == null || searchScope.contains(fileOrDir);
            });
            return !isInScope || processor.process((Object)fileOrDir);
        };
    }

    private static boolean processFile(@NotNull VirtualFile vFile, @NotNull PsiElementVisitor visitor, @NotNull PsiManager psiManager, boolean needReadAction, boolean clearResolveCache) {
        Runnable runnable = () -> AnalysisScope.doProcessFile(visitor, psiManager, vFile, clearResolveCache);
        if (needReadAction && !ApplicationManager.getApplication().isDispatchThread()) {
            AnalysisScope.commitAndRunInSmartMode(runnable, psiManager.getProject());
        } else {
            runnable.run();
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        return indicator == null || !indicator.isCanceled();
    }

    private static void commitAndRunInSmartMode(Runnable runnable, Project project) {
        DumbService dumbService;
        boolean passed;
        do {
            dumbService = DumbService.getInstance(project);
            dumbService.waitForSmartMode();
        } while (!(passed = ((Boolean)PsiDocumentManager.getInstance(project).commitAndRunReadAction(() -> {
            if (dumbService.isDumb()) {
                return false;
            }
            runnable.run();
            return true;
        })).booleanValue()));
    }

    private static boolean shouldHighlightFile(@NotNull PsiFile file) {
        return ProblemHighlightFilter.shouldProcessFileInBatch(file);
    }

    public boolean containsModule(@NotNull Module module) {
        switch (this.myType) {
            case 1: {
                return true;
            }
            case 4: {
                return this.myModule == module;
            }
            case 7: {
                return this.myModules.contains(module);
            }
        }
        return false;
    }

    private static void doProcessFile(@NotNull PsiElementVisitor visitor, @NotNull PsiManager psiManager, @NotNull VirtualFile vFile, boolean clearResolveCache) {
        if (!vFile.isValid()) {
            return;
        }
        PsiFile psiFile = psiManager.findFile(vFile);
        if (psiFile == null || !AnalysisScope.shouldHighlightFile(psiFile)) {
            return;
        }
        psiFile.accept(visitor);
        if (clearResolveCache) {
            psiManager.dropResolveCaches();
            InjectedLanguageManager.getInstance(psiManager.getProject()).dropFileCaches(psiFile);
        }
    }

    protected boolean accept(@NotNull PsiDirectory dir, @NotNull Processor<VirtualFile> processor) {
        Project project = dir.getProject();
        boolean processGeneratedFiles = GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(dir.getVirtualFile(), project);
        return VfsUtilCore.iterateChildrenRecursively(dir.getVirtualFile(), VirtualFileFilter.ALL, fileOrDir -> {
            if (this.isFiltered(fileOrDir)) {
                return true;
            }
            if (!processGeneratedFiles && GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(fileOrDir, project)) {
                return true;
            }
            if (!fileOrDir.isDirectory()) {
                return processor.process((Object)fileOrDir);
            }
            return true;
        });
    }

    public boolean isValid() {
        if (this.myModules != null) {
            for (Module module : this.myModules) {
                if (!module.isDisposed()) continue;
                return false;
            }
            return true;
        }
        if (this.myModule != null) {
            return !this.myModule.isDisposed();
        }
        if (this.myElement != null) {
            return this.myElement.isValid();
        }
        return this.myType == 9 || this.myType == 8 || this.myType == 1;
    }

    @Type
    public int getScopeType() {
        return this.myType;
    }

    @NotNull
    public String getDisplayName() {
        switch (this.myType) {
            case 8: {
                return this.myScope.getDisplayName();
            }
            case 4: {
                return AnalysisScopeBundle.message("scope.option.module", AnalysisScope.pathToName(this.myModule.getModuleFilePath()));
            }
            case 7: {
                String modules = StringUtil.join(this.myModules, module -> AnalysisScope.pathToName(module.getModuleFilePath()), (String)", ");
                return AnalysisScopeBundle.message("scope.module.list", modules, this.myModules.size());
            }
            case 1: {
                return AnalysisScopeBundle.message("scope.project", this.myProject.getName());
            }
            case 3: {
                return AnalysisScopeBundle.message("scope.file", AnalysisScope.displayProjectRelativePath((PsiFileSystemItem)this.myElement));
            }
            case 2: {
                return AnalysisScopeBundle.message("scope.directory", AnalysisScope.displayProjectRelativePath((PsiFileSystemItem)this.myElement));
            }
            case 9: {
                return AnalysisScopeBundle.message("scope.virtual.files", new Object[0]);
            }
        }
        return "";
    }

    @NotNull
    public String getShortenName() {
        switch (this.myType) {
            case 8: {
                return this.myScope.getDisplayName();
            }
            case 4: {
                return AnalysisScopeBundle.message("scope.option.module", this.myModule.getName());
            }
            case 7: {
                String modules = StringUtil.join(this.myModules, Module::getName, (String)", ");
                return AnalysisScopeBundle.message("scope.module.list", modules, this.myModules.size());
            }
            case 1: {
                return AnalysisScopeBundle.message("scope.project", this.myProject.getName());
            }
            case 3: {
                String relativePath = this.getRelativePath();
                return AnalysisScopeBundle.message("scope.file", relativePath);
            }
            case 2: {
                String relativeDirPath = this.getRelativePath();
                return AnalysisScopeBundle.message("scope.directory", relativeDirPath);
            }
            case 9: {
                return AnalysisScopeBundle.message("scope.selected.files", new Object[0]);
            }
        }
        return "";
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    public Module getModule() {
        return this.myModule;
    }

    @NotNull
    public List<Module> getModules() {
        return this.myModules == null ? Collections.emptyList() : Collections.unmodifiableList(this.myModules);
    }

    @Nullable
    public PsiElement getElement() {
        return this.myElement;
    }

    @NotNull
    public Set<VirtualFile> getFiles() {
        return this.myVFiles == null ? Collections.emptySet() : Collections.unmodifiableSet(this.myVFiles);
    }

    @Nullable
    private String getRelativePath() {
        String relativePath = AnalysisScope.displayProjectRelativePath((PsiFileSystemItem)this.myElement);
        if (relativePath.length() > 100) {
            return ((PsiFileSystemItem)this.myElement).getName();
        }
        return relativePath;
    }

    @NotNull
    private static String pathToName(@NotNull String path2) {
        File file = new File(path2);
        return FileUtil.getNameWithoutExtension((File)file);
    }

    public int getFileCount() {
        ProgressIndicator indicator;
        if (this.myFilesSet == null) {
            this.initFilesSet();
        }
        if ((indicator = ProgressManager.getInstance().getProgressIndicator()) != null) {
            indicator.setText("");
            indicator.setText2("");
        }
        return this.myFilesSet.size();
    }

    public void invalidate() {
        if (this.myType == 9) {
            this.myVFiles.removeIf(virtualFile2 -> virtualFile2 == null || !virtualFile2.isValid());
        } else {
            this.myFilesSet = null;
        }
    }

    public boolean containsSources(boolean isTest) {
        if (this.myElement != null) {
            VirtualFile file;
            Project project = this.myElement.getProject();
            ProjectFileIndex index = ProjectRootManager.getInstance(project).getFileIndex();
            if (this.myElement instanceof PsiDirectory) {
                VirtualFile directory = ((PsiFileSystemItem)this.myElement).getVirtualFile();
                if (index.isInSourceContent(directory)) {
                    return isTest == TestSourcesFilter.isTestSources(directory, this.myProject);
                }
            } else if (this.myElement instanceof PsiFile && (file = ((PsiFileSystemItem)this.myElement).getVirtualFile()) != null) {
                return isTest == TestSourcesFilter.isTestSources(file, this.myProject);
            }
        }
        return true;
    }

    @NotNull
    public AnalysisScope getNarrowedComplementaryScope(@NotNull Project defaultProject) {
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(defaultProject).getFileIndex();
        HashSet<Module> modules = new HashSet<Module>();
        if (this.myType == 3 || this.myType == 2) {
            VirtualFile vFile = ((PsiFileSystemItem)this.myElement).getVirtualFile();
            modules.addAll(AnalysisScope.getAllInterestingModules(fileIndex, vFile));
        } else if (this.myType == 4) {
            modules.add(this.myModule);
        } else if (this.myType == 7) {
            modules.addAll(this.myModules);
        }
        return AnalysisScope.collectScopes(defaultProject, modules);
    }

    @NotNull
    static AnalysisScope collectScopes(@NotNull Project defaultProject, @NotNull HashSet<Module> modules) {
        if (modules.isEmpty()) {
            return new AnalysisScope(defaultProject);
        }
        Module[] allModules = ModuleManager.getInstance(defaultProject).getModules();
        HashSet<Module> modulesToAnalyze = new HashSet<Module>();
        for (Module module : modules) {
            modulesToAnalyze.addAll(AnalysisScope.getDirectBackwardDependencies(module, allModules));
            modulesToAnalyze.addAll(AnalysisScope.getExportBackwardDependencies(module, allModules));
            modulesToAnalyze.add(module);
        }
        return new AnalysisScope(modulesToAnalyze.toArray(new Module[modulesToAnalyze.size()]));
    }

    @NotNull
    private static Set<Module> getExportBackwardDependencies(@NotNull Module fromModule, @NotNull Module[] allModules) {
        HashSet<Module> result = new HashSet<Module>();
        for (Module module : allModules) {
            OrderEntry[] orderEntries;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
            for (OrderEntry orderEntry : orderEntries = moduleRootManager.getOrderEntries()) {
                if (!(orderEntry instanceof ModuleOrderEntry) || !((ExportableOrderEntry)orderEntry).isExported() || fromModule != ((ModuleOrderEntry)orderEntry).getModule()) continue;
                result.addAll(AnalysisScope.getDirectBackwardDependencies(module, allModules));
            }
        }
        return result;
    }

    @NotNull
    private static Set<Module> getDirectBackwardDependencies(@NotNull Module module, @NotNull Module[] allModules) {
        HashSet<Module> result = new HashSet<Module>();
        for (Module dependency : allModules) {
            if (ArrayUtil.find((Object[])ModuleRootManager.getInstance(dependency).getDependencies(), (Object)module) <= -1) continue;
            result.add(dependency);
        }
        return result;
    }

    @NotNull
    static HashSet<Module> getAllInterestingModules(@NotNull ProjectFileIndex fileIndex, @NotNull VirtualFile vFile) {
        HashSet<Module> modules = new HashSet<Module>();
        if (fileIndex.isInLibrarySource(vFile) || fileIndex.isInLibraryClasses(vFile)) {
            for (OrderEntry orderEntry : fileIndex.getOrderEntriesForFile(vFile)) {
                modules.add(orderEntry.getOwnerModule());
            }
        } else {
            modules.add(fileIndex.getModuleForFile(vFile));
        }
        return modules;
    }

    @NotNull
    public SearchScope toSearchScope() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        switch (this.myType) {
            case 8: {
                return this.myScope;
            }
            case 2: {
                return GlobalSearchScopesCore.directoryScope((PsiDirectory)this.myElement, true);
            }
            case 3: {
                return new LocalSearchScope(this.myElement);
            }
            case 6: {
                return LocalSearchScope.EMPTY;
            }
            case 4: {
                GlobalSearchScope moduleScope = GlobalSearchScope.moduleScope(this.myModule);
                return this.myIncludeTestSource ? moduleScope : GlobalSearchScope.notScope(GlobalSearchScopesCore.projectTestScope(this.myModule.getProject())).intersectWith(moduleScope);
            }
            case 7: {
                SearchScope scope = GlobalSearchScope.EMPTY_SCOPE;
                for (Module module : this.myModules) {
                    scope = ((SearchScope)scope).union(GlobalSearchScope.moduleScope(module));
                }
                return scope;
            }
            case 1: {
                return this.myIncludeTestSource ? GlobalSearchScope.projectScope(this.myProject) : GlobalSearchScopesCore.projectProductionScope(this.myProject);
            }
            case 9: {
                return new GlobalSearchScope(){

                    @Override
                    public boolean contains(@NotNull VirtualFile file) {
                        return AnalysisScope.this.myFilesSet.contains(file);
                    }

                    @Override
                    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                        return 0;
                    }

                    @Override
                    public boolean isSearchInModuleContent(@NotNull Module aModule) {
                        return false;
                    }

                    @Override
                    public boolean isSearchInLibraries() {
                        return false;
                    }
                };
            }
        }
        LOG.error("invalid type " + this.myType);
        return GlobalSearchScope.EMPTY_SCOPE;
    }

    boolean isAnalyzeTestsByDefault() {
        switch (this.myType) {
            case 2: {
                return TestSourcesFilter.isTestSources(((PsiDirectory)this.myElement).getVirtualFile(), this.myElement.getProject());
            }
            case 3: {
                PsiFile containingFile = this.myElement.getContainingFile();
                return TestSourcesFilter.isTestSources(containingFile.getVirtualFile(), containingFile.getProject());
            }
            case 4: {
                return AnalysisScope.isTestOnly(this.myModule);
            }
            case 7: {
                for (Module module : this.myModules) {
                    if (AnalysisScope.isTestOnly(module)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isTestOnly(@NotNull Module module) {
        return ModuleRootManager.getInstance(module).getSourceRootUrls(false).length == 0;
    }

    public boolean isIncludeTestSource() {
        return this.myIncludeTestSource;
    }

    public void setFilter(GlobalSearchScope filter) {
        this.myFilter = filter;
    }

    public static @interface Type {
    }
}

