/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodeInsightAction
extends AnAction {
    @Override
    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project != null) {
            Editor editor = this.getEditor(e.getDataContext(), project, false);
            this.actionPerformedImpl(project, editor);
        }
    }

    @Override
    public boolean startInTransaction() {
        return true;
    }

    @Nullable
    protected Editor getEditor(@NotNull DataContext dataContext, @NotNull Project project, boolean forUpdate) {
        return CommonDataKeys.EDITOR.getData(dataContext);
    }

    public void actionPerformedImpl(@NotNull Project project, Editor editor) {
        if (editor == null) {
            return;
        }
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor(editor, project);
        if (psiFile == null) {
            return;
        }
        CodeInsightActionHandler handler = this.getHandler();
        PsiElement elementToMakeWritable = handler.getElementToMakeWritable(psiFile);
        if (!(elementToMakeWritable == null || EditorModificationUtil.checkModificationAllowed(editor) && FileModificationService.getInstance().preparePsiElementsForWrite(elementToMakeWritable))) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, () -> {
            Runnable action = () -> {
                if (!ApplicationManager.getApplication().isUnitTestMode() && !editor.getContentComponent().isShowing()) {
                    return;
                }
                handler.invoke(project, editor, psiFile);
            };
            if (handler.startInWriteAction()) {
                ApplicationManager.getApplication().runWriteAction(action);
            } else {
                action.run();
            }
        }, this.getCommandName(), DocCommandGroupId.noneGroupId(editor.getDocument()));
    }

    @Override
    public void beforeActionPerformedUpdate(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project != null) {
            PsiDocumentManager.getInstance(project).commitAllDocuments();
        }
        super.beforeActionPerformedUpdate(e);
    }

    @Override
    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        DataContext dataContext = e.getDataContext();
        Editor editor = this.getEditor(dataContext, project, true);
        if (editor == null) {
            presentation.setEnabled(false);
            return;
        }
        PsiFile file = PsiUtilBase.getPsiFileInEditor(editor, project);
        if (file == null) {
            presentation.setEnabled(false);
            return;
        }
        this.update(presentation, project, editor, file, dataContext, e.getPlace());
    }

    protected void update(@NotNull Presentation presentation, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        presentation.setEnabled(this.isValidForFile(project, editor, file));
    }

    protected void update(@NotNull Presentation presentation, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext, @Nullable String actionPlace) {
        this.update(presentation, project, editor, file);
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        return true;
    }

    @NotNull
    protected abstract CodeInsightActionHandler getHandler();

    protected String getCommandName() {
        String text = this.getTemplatePresentation().getText();
        return text == null ? "" : text;
    }
}

