/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InsertionContext {
    public static final OffsetKey TAIL_OFFSET = OffsetKey.create("tailOffset", true);
    private final OffsetMap myOffsetMap;
    private final char myCompletionChar;
    private final LookupElement[] myElements;
    private final PsiFile myFile;
    private final Editor myEditor;
    private Runnable myLaterRunnable;
    private boolean myAddCompletionChar;

    public InsertionContext(OffsetMap offsetMap, char completionChar, LookupElement[] elements, @NotNull PsiFile file, @NotNull Editor editor, boolean addCompletionChar) {
        this.myOffsetMap = offsetMap;
        this.myCompletionChar = completionChar;
        this.myElements = elements;
        this.myFile = file;
        this.myEditor = editor;
        this.setTailOffset(editor.getCaretModel().getOffset());
        this.myAddCompletionChar = addCompletionChar;
    }

    public void setTailOffset(int offset) {
        this.myOffsetMap.addOffset(TAIL_OFFSET, offset);
    }

    public int getTailOffset() {
        return this.myOffsetMap.getOffset(TAIL_OFFSET);
    }

    @NotNull
    public PsiFile getFile() {
        return this.myFile;
    }

    @NotNull
    public Editor getEditor() {
        return this.myEditor;
    }

    public void commitDocument() {
        PsiDocumentManager.getInstance(this.getProject()).commitDocument(this.getDocument());
    }

    @NotNull
    public Document getDocument() {
        return this.getEditor().getDocument();
    }

    public int getOffset(OffsetKey key) {
        return this.getOffsetMap().getOffset(key);
    }

    public OffsetMap getOffsetMap() {
        return this.myOffsetMap;
    }

    public OffsetKey trackOffset(int offset, boolean moveableToRight) {
        OffsetKey key = OffsetKey.create("tracked", moveableToRight);
        this.getOffsetMap().addOffset(key, offset);
        return key;
    }

    public int getStartOffset() {
        return this.myOffsetMap.getOffset(CompletionInitializationContext.START_OFFSET);
    }

    public char getCompletionChar() {
        return this.myCompletionChar;
    }

    public LookupElement[] getElements() {
        return this.myElements;
    }

    public Project getProject() {
        return this.myFile.getProject();
    }

    public int getSelectionEndOffset() {
        return this.myOffsetMap.getOffset(CompletionInitializationContext.SELECTION_END_OFFSET);
    }

    @Nullable
    public Runnable getLaterRunnable() {
        return this.myLaterRunnable;
    }

    public void setLaterRunnable(@Nullable Runnable laterRunnable) {
        this.myLaterRunnable = laterRunnable;
    }

    public void setAddCompletionChar(boolean addCompletionChar) {
        this.myAddCompletionChar = addCompletionChar;
    }

    public boolean shouldAddCompletionChar() {
        return this.myAddCompletionChar;
    }

    public CommonCodeStyleSettings getCodeStyleSettings() {
        Language lang = PsiUtilCore.getLanguageAtOffset(this.getFile(), this.getTailOffset());
        return CodeStyleSettingsManager.getSettings(this.getProject()).getCommonSettings(lang);
    }
}

