/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.fixtures.LightCodeInsightFixtureTestCase;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class LightFixtureCompletionTestCase
extends LightCodeInsightFixtureTestCase {
    protected LookupElement[] myItems;

    @Override
    @NotNull
    protected LightProjectDescriptor getProjectDescriptor() {
        return JAVA_1_6;
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.myItems = null;
            CodeInsightSettings.getInstance().COMPLETION_CASE_SENSITIVE = 3;
        }
        finally {
            super.tearDown();
        }
    }

    protected void configureByFile(String path2) {
        this.myFixture.configureFromExistingVirtualFile(this.myFixture.copyFileToProject(path2, StringUtil.getShortName((String)path2, (char)'/')));
        this.complete();
    }

    protected void configureByTestName() {
        this.configureByFile("/" + this.getTestName(false) + ".java");
    }

    protected void doAntiTest() {
        this.configureByTestName();
        this.checkResultByFile(this.getTestName(false) + ".java");
        LightFixtureCompletionTestCase.assertEmpty((Object[])this.myItems);
        LightFixtureCompletionTestCase.assertNull((Object)this.getLookup());
    }

    protected void complete() {
        this.myItems = this.myFixture.completeBasic();
    }

    protected void selectItem(LookupElement item) {
        this.selectItem(item, '\u0000');
    }

    protected void checkResultByFile(String path2) {
        this.myFixture.checkResultByFile(path2);
    }

    protected void selectItem(@NotNull LookupElement item, char completionChar) {
        LookupImpl lookup = this.getLookup();
        lookup.setCurrentItem(item);
        if (LookupEvent.isSpecialCompletionChar(completionChar)) {
            lookup.finishLookup(completionChar);
        } else {
            this.type(completionChar);
        }
    }

    protected LookupImpl getLookup() {
        return (LookupImpl)LookupManager.getInstance((Project)this.getProject()).getActiveLookup();
    }

    protected void assertFirstStringItems(String ... items) {
        List strings = this.myFixture.getLookupElementStrings();
        LightFixtureCompletionTestCase.assertNotNull((Object)strings);
        LightFixtureCompletionTestCase.assertOrderedEquals(strings.subList(0, Math.min(items.length, strings.size())), (Object[])items);
    }

    protected void assertStringItems(String ... items) {
        LightFixtureCompletionTestCase.assertOrderedEquals((Iterable)this.myFixture.getLookupElementStrings(), (Object[])items);
    }

    protected void type(String s) {
        this.myFixture.type(s);
    }

    protected void type(char c) {
        this.myFixture.type(c);
    }
}

