/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MergeableLineMarkerInfo<T extends PsiElement>
extends LineMarkerInfo<T> {
    public MergeableLineMarkerInfo(@NotNull T element, @NotNull TextRange textRange, Icon icon, int updatePass, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler, @NotNull GutterIconRenderer.Alignment alignment) {
        super(element, textRange, icon, updatePass, tooltipProvider, navHandler, alignment);
    }

    public abstract boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> var1);

    public abstract Icon getCommonIcon(@NotNull List<MergeableLineMarkerInfo> var1);

    @NotNull
    public abstract Function<? super PsiElement, String> getCommonTooltip(@NotNull List<MergeableLineMarkerInfo> var1);

    public GutterIconRenderer.Alignment getCommonIconAlignment(@NotNull List<MergeableLineMarkerInfo> infos) {
        return GutterIconRenderer.Alignment.LEFT;
    }

    public String getElementPresentation(PsiElement element) {
        return element.getText();
    }

    public int getCommonUpdatePass(@NotNull List<MergeableLineMarkerInfo> infos) {
        return this.updatePass;
    }

    public boolean configurePopupAndRenderer(@NotNull PopupChooserBuilder builder, @NotNull JBList list, @NotNull List<MergeableLineMarkerInfo> markers) {
        return false;
    }

    @NotNull
    public static List<LineMarkerInfo> merge(@NotNull List<MergeableLineMarkerInfo> markers) {
        SmartList result = new SmartList();
        for (int i2 = 0; i2 < markers.size(); ++i2) {
            MergeableLineMarkerInfo marker = markers.get(i2);
            SmartList toMerge = new SmartList();
            for (int k = markers.size() - 1; k > i2; --k) {
                MergeableLineMarkerInfo current = markers.get(k);
                if (!marker.canMergeWith(current)) continue;
                toMerge.add(0, current);
                markers.remove(k);
            }
            if (toMerge.isEmpty()) {
                result.add(marker);
                continue;
            }
            toMerge.add(0, marker);
            result.add(new MyLineMarkerInfo((List)toMerge));
        }
        return result;
    }

    private static class MyLineMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        private MyLineMarkerInfo(@NotNull List<MergeableLineMarkerInfo> markers) {
            this(markers, markers.get(0));
        }

        private MyLineMarkerInfo(@NotNull List<MergeableLineMarkerInfo> markers, @NotNull MergeableLineMarkerInfo template) {
            super(template.getElement(), MyLineMarkerInfo.getCommonTextRange(markers), template.getCommonIcon(markers), template.getCommonUpdatePass(markers), template.getCommonTooltip(markers), MyLineMarkerInfo.getCommonNavigationHandler(markers), template.getCommonIconAlignment(markers));
        }

        private static TextRange getCommonTextRange(List<MergeableLineMarkerInfo> markers) {
            int startOffset = Integer.MAX_VALUE;
            int endOffset = Integer.MIN_VALUE;
            for (MergeableLineMarkerInfo marker : markers) {
                startOffset = Math.min(startOffset, marker.startOffset);
                endOffset = Math.max(endOffset, marker.endOffset);
            }
            return TextRange.create((int)startOffset, (int)endOffset);
        }

        private static GutterIconNavigationHandler<PsiElement> getCommonNavigationHandler(final @NotNull List<MergeableLineMarkerInfo> markers) {
            return new GutterIconNavigationHandler<PsiElement>(){

                @Override
                public void navigate(MouseEvent e, PsiElement elt) {
                    ArrayList<MergeableLineMarkerInfo> infos = new ArrayList<MergeableLineMarkerInfo>(markers);
                    Collections.sort(infos, (o1, o2) -> o1.startOffset - o2.startOffset);
                    JBList list = new JBList(infos);
                    list.setFixedCellHeight(20);
                    PopupChooserBuilder builder = JBPopupFactory.getInstance().createListPopupBuilder(list);
                    if (!((MergeableLineMarkerInfo)markers.get(0)).configurePopupAndRenderer(builder, list, infos)) {
                        list.installCellRenderer(dom -> {
                            if (dom instanceof LineMarkerInfo) {
                                Icon icon = null;
                                GutterIconRenderer renderer = ((LineMarkerInfo)dom).createGutterRenderer();
                                if (renderer != null) {
                                    icon = renderer.getIcon();
                                }
                                Object element = ((LineMarkerInfo)dom).getElement();
                                assert (element != null);
                                String elementPresentation = dom instanceof MergeableLineMarkerInfo ? ((MergeableLineMarkerInfo)dom).getElementPresentation((PsiElement)element) : element.getText();
                                String text = StringUtil.first((String)elementPresentation, (int)100, (boolean)true).replace('\n', ' ');
                                JBLabel label = new JBLabel(text, icon, 2);
                                label.setBorder(IdeBorderFactory.createEmptyBorder(2));
                                return label;
                            }
                            return new JBLabel();
                        });
                    }
                    builder.setItemChoosenCallback(() -> {
                        GutterIconNavigationHandler handler;
                        Object value = list.getSelectedValue();
                        if (value instanceof LineMarkerInfo && (handler = ((LineMarkerInfo)value).getNavigationHandler()) != null) {
                            handler.navigate(e, ((LineMarkerInfo)value).getElement());
                        }
                    }).createPopup().show(new RelativePoint(e));
                }
            };
        }
    }
}

