/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReadWriteAccessDetector {
    public static final ExtensionPointName<ReadWriteAccessDetector> EP_NAME = ExtensionPointName.create((String)"com.intellij.readWriteAccessDetector");

    @Nullable
    public static ReadWriteAccessDetector findDetector(@NotNull PsiElement element) {
        ReadWriteAccessDetector detector = null;
        for (ReadWriteAccessDetector accessDetector : (ReadWriteAccessDetector[])Extensions.getExtensions(EP_NAME)) {
            if (!accessDetector.isReadWriteAccessible(element)) continue;
            detector = accessDetector;
            break;
        }
        return detector;
    }

    public abstract boolean isReadWriteAccessible(@NotNull PsiElement var1);

    public abstract boolean isDeclarationWriteAccess(@NotNull PsiElement var1);

    @NotNull
    public abstract Access getReferenceAccess(@NotNull PsiElement var1, @NotNull PsiReference var2);

    @NotNull
    public abstract Access getExpressionAccess(@NotNull PsiElement var1);

    public static enum Access {
        Read,
        Write,
        ReadWrite;

    }
}

