/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PriorityActionWrapper
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final LocalQuickFixAndIntentionActionOnPsiElement fix;

    private PriorityActionWrapper(PsiElement element, @NotNull LocalQuickFixAndIntentionActionOnPsiElement fix) {
        super(element);
        this.fix = fix;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return this.fix.getFamilyName();
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        return this.fix.isAvailable(project, file, startElement, endElement);
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        this.fix.invoke(project, file, editor, startElement, endElement);
    }

    @Override
    public boolean startInWriteAction() {
        return this.fix.startInWriteAction();
    }

    @Override
    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        return this.fix.getElementToMakeWritable(file);
    }

    @Override
    @NotNull
    public String getText() {
        return this.fix.getName();
    }

    @NotNull
    public static LocalQuickFixAndIntentionActionOnPsiElement highPriority(PsiElement element, @NotNull LocalQuickFixAndIntentionActionOnPsiElement fix) {
        return new HighPriorityLocalQuickFixWrapper(element, fix);
    }

    @NotNull
    public static LocalQuickFixAndIntentionActionOnPsiElement normalPriority(PsiElement element, @NotNull LocalQuickFixAndIntentionActionOnPsiElement fix) {
        return new NormalPriorityLocalQuickFixWrapper(element, fix);
    }

    @NotNull
    public static LocalQuickFixAndIntentionActionOnPsiElement lowPriority(PsiElement element, @NotNull LocalQuickFixAndIntentionActionOnPsiElement fix) {
        return new LowPriorityLocalQuickFixWrapper(element, fix);
    }

    private static class LowPriorityLocalQuickFixWrapper
    extends PriorityActionWrapper
    implements LowPriorityAction {
        protected LowPriorityLocalQuickFixWrapper(PsiElement element, @NotNull LocalQuickFixAndIntentionActionOnPsiElement fix) {
            super(element, fix);
        }
    }

    private static class NormalPriorityLocalQuickFixWrapper
    extends PriorityActionWrapper {
        protected NormalPriorityLocalQuickFixWrapper(PsiElement element, @NotNull LocalQuickFixAndIntentionActionOnPsiElement fix) {
            super(element, fix);
        }
    }

    private static class HighPriorityLocalQuickFixWrapper
    extends PriorityActionWrapper
    implements HighPriorityAction {
        protected HighPriorityLocalQuickFixWrapper(PsiElement element, @NotNull LocalQuickFixAndIntentionActionOnPsiElement fix) {
            super(element, fix);
        }
    }
}

