/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.WeighingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LookupElementWeigher {
    private final String myId;
    private final boolean myNegated;
    private final boolean myPrefixDependent;

    protected LookupElementWeigher(String id, boolean negated, boolean dependsOnPrefix) {
        this.myId = id;
        this.myNegated = negated;
        this.myPrefixDependent = dependsOnPrefix;
    }

    protected LookupElementWeigher(String id) {
        this(id, false, false);
    }

    public boolean isPrefixDependent() {
        return this.myPrefixDependent;
    }

    public boolean isNegated() {
        return this.myNegated;
    }

    public String toString() {
        return this.myId;
    }

    @Nullable
    public Comparable weigh(@NotNull LookupElement element, @NotNull WeighingContext context) {
        return this.weigh(element);
    }

    @Nullable
    public Comparable weigh(@NotNull LookupElement element) {
        throw new UnsupportedOperationException("weigh not implemented in " + this.getClass());
    }
}

