/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.OptionAccessor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;

public class MultipleCheckboxOptionsPanel
extends JPanel {
    private final OptionAccessor myOptionAccessor;

    public MultipleCheckboxOptionsPanel(InspectionProfileEntry owner) {
        this(new OptionAccessor.Default(owner));
    }

    public MultipleCheckboxOptionsPanel(OptionAccessor optionAccessor) {
        super(new GridBagLayout());
        this.myOptionAccessor = optionAccessor;
    }

    public void addCheckbox(String label, @NonNls String property) {
        boolean selected = this.myOptionAccessor.getOption(property);
        JCheckBox checkBox = new JCheckBox(label, selected);
        MultipleCheckboxOptionsPanel.configureCheckbox(this.myOptionAccessor, property, checkBox);
        this.addComponent(checkBox);
    }

    public void addComponent(JComponent component) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 23;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        Component[] components = this.getComponents();
        this.removeAll();
        for (Component component1 : components) {
            this.add(component1, constraints);
            ++constraints.gridy;
        }
        constraints.weighty = 1.0;
        this.add((Component)component, constraints);
    }

    private static void configureCheckbox(OptionAccessor accessor, String property, JCheckBox checkBox) {
        ButtonModel model = checkBox.getModel();
        CheckboxChangeListener changeListener = new CheckboxChangeListener(accessor, property, model);
        model.addChangeListener(changeListener);
    }

    public static void initAndConfigureCheckbox(InspectionProfileEntry owner, String property, JCheckBox checkBox) {
        OptionAccessor.Default optionAccessor = new OptionAccessor.Default(owner);
        checkBox.setSelected(optionAccessor.getOption(property));
        MultipleCheckboxOptionsPanel.configureCheckbox(optionAccessor, property, checkBox);
    }

    private static class CheckboxChangeListener
    implements ChangeListener {
        private final OptionAccessor myAccessor;
        private final String property;
        private final ButtonModel model;

        CheckboxChangeListener(OptionAccessor myAccessor, String property, ButtonModel model) {
            this.myAccessor = myAccessor;
            this.property = property;
            this.model = model;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.myAccessor.setOption(this.property, this.model.isSelected());
        }
    }
}

