/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.ui.DocumentAdapter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.Document;
import javax.swing.text.NumberFormatter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SingleIntegerFieldOptionsPanel
extends JPanel {
    public SingleIntegerFieldOptionsPanel(String labelString, InspectionProfileEntry owner, @NonNls String property) {
        this(labelString, owner, property, 2);
    }

    public SingleIntegerFieldOptionsPanel(String labelString, InspectionProfileEntry owner, @NonNls String property, int integerFieldColumns) {
        super(new GridBagLayout());
        JLabel label = new JLabel(labelString);
        JFormattedTextField valueField = SingleIntegerFieldOptionsPanel.createIntegerFieldTrackingValue(owner, property, integerFieldColumns);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets.right = 10;
        constraints.weightx = 0.0;
        constraints.anchor = 512;
        constraints.fill = 0;
        this.add((Component)label, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets.right = 0;
        constraints.anchor = 512;
        constraints.fill = 0;
        this.add((Component)valueField, constraints);
    }

    public static JFormattedTextField createIntegerFieldTrackingValue(@NotNull InspectionProfileEntry owner, @NotNull String property, int integerFieldColumns) {
        JFormattedTextField valueField = new JFormattedTextField();
        valueField.setColumns(integerFieldColumns);
        SingleIntegerFieldOptionsPanel.setupIntegerFieldTrackingValue(valueField, owner, property);
        return valueField;
    }

    public static void setupIntegerFieldTrackingValue(final JFormattedTextField textField, final InspectionProfileEntry owner, final String property) {
        NumberFormat formatter = NumberFormat.getIntegerInstance();
        formatter.setParseIntegerOnly(true);
        textField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(formatter)));
        textField.setValue(SingleIntegerFieldOptionsPanel.getPropertyValue(owner, property));
        Document document = textField.getDocument();
        document.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent e) {
                try {
                    textField.commitEdit();
                    SingleIntegerFieldOptionsPanel.setPropertyValue(owner, property, ((Number)textField.getValue()).intValue());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        });
    }

    private static void setPropertyValue(InspectionProfileEntry owner, String property, int value) {
        try {
            owner.getClass().getField(property).setInt(owner, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int getPropertyValue(InspectionProfileEntry owner, String property) {
        try {
            return owner.getClass().getField(property).getInt(owner);
        }
        catch (Exception e) {
            return 0;
        }
    }
}

