/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.openapi.module.Module;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ModuleSourceSet {
    private final Module myModule;
    private final Type myType;

    public ModuleSourceSet(@NotNull Module module, @NotNull Type type) {
        this.myModule = module;
        this.myType = type;
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    @NotNull
    public Type getType() {
        return this.myType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleSourceSet set = (ModuleSourceSet)o;
        return this.myModule.equals(set.myModule) && this.myType == set.myType;
    }

    public int hashCode() {
        return 31 * this.myModule.hashCode() + this.myType.hashCode();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return (this.myType == Type.PRODUCTION ? "" : "Tests of ") + "'" + this.myModule.getName() + "' module";
    }

    @NotNull
    public static Set<Module> getModules(@NotNull Collection<ModuleSourceSet> sourceSets) {
        return sourceSets.stream().map(ModuleSourceSet::getModule).collect(Collectors.toSet());
    }

    public static enum Type {
        PRODUCTION,
        TEST;

    }
}

