/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.SourcePosition;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.Nullable;

public abstract class SourcePositionHighlighter {
    public static final ExtensionPointName<SourcePositionHighlighter> EP_NAME = ExtensionPointName.create((String)"com.intellij.debugger.sourcePositionHighlighter");

    public abstract TextRange getHighlightRange(SourcePosition var1);

    @Nullable
    public static TextRange getHighlightRangeFor(SourcePosition sourcePosition) {
        DumbService dumbService = DumbService.getInstance(sourcePosition.getFile().getProject());
        for (SourcePositionHighlighter sourcePositionHighlighter : dumbService.filterByDumbAwareness(EP_NAME.getExtensions())) {
            TextRange range = sourcePositionHighlighter.getHighlightRange(sourcePosition);
            if (range == null) continue;
            return range;
        }
        return null;
    }
}

