/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.openapi.util.Couple;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Side
extends Enum<Side> {
    public static final /* enum */ Side LEFT = new Side(0);
    public static final /* enum */ Side RIGHT = new Side(1);
    private final int myIndex;
    private static final /* synthetic */ Side[] $VALUES;

    public static Side[] values() {
        return (Side[])$VALUES.clone();
    }

    public static Side valueOf(String name) {
        return Enum.valueOf(Side.class, name);
    }

    private Side(int index) {
        this.myIndex = index;
    }

    @NotNull
    public static Side fromIndex(int index) {
        if (index == 0) {
            return LEFT;
        }
        if (index == 1) {
            return RIGHT;
        }
        throw new IndexOutOfBoundsException("index: " + index);
    }

    @NotNull
    public static Side fromLeft(boolean isLeft) {
        return isLeft ? LEFT : RIGHT;
    }

    @NotNull
    public static Side fromRight(boolean isRight) {
        return isRight ? RIGHT : LEFT;
    }

    public int getIndex() {
        return this.myIndex;
    }

    public boolean isLeft() {
        return this.myIndex == 0;
    }

    @NotNull
    public Side other() {
        return this.isLeft() ? RIGHT : LEFT;
    }

    @NotNull
    public Side other(boolean other) {
        return other ? this.other() : this;
    }

    public int select(int left, int right) {
        return this.isLeft() ? left : right;
    }

    @Nullable
    @Contract(value="!null, !null -> !null; null, null -> null")
    public <T> T select(@Nullable T left, @Nullable T right) {
        return this.isLeft() ? left : right;
    }

    @NotNull
    public <T> T selectNotNull(@NotNull T left, @NotNull T right) {
        return this.isLeft() ? left : right;
    }

    public boolean select(@NotNull boolean[] array) {
        assert (array.length == 2);
        return array[this.myIndex];
    }

    public int select(@NotNull int[] array) {
        assert (array.length == 2);
        return array[this.myIndex];
    }

    public <T> T select(@NotNull T[] array) {
        assert (array.length == 2);
        return array[this.myIndex];
    }

    @NotNull
    public <T> T selectNotNull(@NotNull T[] array) {
        assert (array.length == 2);
        return array[this.myIndex];
    }

    public <T> T select(@NotNull List<T> list) {
        assert (list.size() == 2);
        return list.get(this.myIndex);
    }

    @NotNull
    public <T> T selectNotNull(@NotNull List<T> list) {
        assert (list.size() == 2);
        return list.get(this.myIndex);
    }

    public <T> T select(@NotNull Couple<T> region) {
        return (T)(this.isLeft() ? region.first : region.second);
    }

    @NotNull
    public <T> T selectNotNull(@NotNull Couple<T> region) {
        return (T)(this.isLeft() ? region.first : region.second);
    }

    @Nullable
    public static <T> Side fromValue(@NotNull List<? extends T> list, @Nullable T value) {
        assert (list.size() == 2);
        int index = list.indexOf(value);
        return index != -1 ? Side.fromIndex(index) : null;
    }

    public int getStartOffset(@NotNull DiffFragment fragment) {
        return this.isLeft() ? fragment.getStartOffset1() : fragment.getStartOffset2();
    }

    public int getEndOffset(@NotNull DiffFragment fragment) {
        return this.isLeft() ? fragment.getEndOffset1() : fragment.getEndOffset2();
    }

    public int getStartLine(@NotNull LineFragment fragment) {
        return this.isLeft() ? fragment.getStartLine1() : fragment.getStartLine2();
    }

    public int getEndLine(@NotNull LineFragment fragment) {
        return this.isLeft() ? fragment.getEndLine1() : fragment.getEndLine2();
    }

    static {
        $VALUES = new Side[]{LEFT, RIGHT};
    }
}

