/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralCommandLine
implements UserDataHolder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.configurations.GeneralCommandLine");
    private String myExePath;
    private File myWorkDirectory;
    private final Map<String, String> myEnvParams = new MyTHashMap();
    private ParentEnvironmentType myParentEnvironmentType = ParentEnvironmentType.CONSOLE;
    private final ParametersList myProgramParams = new ParametersList();
    private Charset myCharset = CharsetToolkit.getDefaultSystemCharset();
    private boolean myRedirectErrorStream = false;
    private Map<Object, Object> myUserData;

    public GeneralCommandLine() {
    }

    public GeneralCommandLine(String ... command) {
        this(Arrays.asList(command));
    }

    public GeneralCommandLine(@NotNull List<String> command) {
        int size = command.size();
        if (size > 0) {
            this.setExePath(command.get(0));
            if (size > 1) {
                this.addParameters(command.subList(1, size));
            }
        }
    }

    @NotNull
    public String getExePath() {
        return this.myExePath;
    }

    @NotNull
    public GeneralCommandLine withExePath(@NotNull String exePath) {
        this.myExePath = exePath.trim();
        return this;
    }

    public void setExePath(@NotNull String exePath) {
        this.withExePath(exePath);
    }

    public File getWorkDirectory() {
        return this.myWorkDirectory;
    }

    @NotNull
    public GeneralCommandLine withWorkDirectory(@Nullable String path2) {
        return this.withWorkDirectory(path2 != null ? new File(path2) : null);
    }

    @NotNull
    public GeneralCommandLine withWorkDirectory(@Nullable File workDirectory) {
        this.myWorkDirectory = workDirectory;
        return this;
    }

    public void setWorkDirectory(@Nullable String path2) {
        this.withWorkDirectory(path2);
    }

    public void setWorkDirectory(@Nullable File workDirectory) {
        this.withWorkDirectory(workDirectory);
    }

    @NotNull
    public Map<String, String> getEnvironment() {
        return this.myEnvParams;
    }

    @NotNull
    public GeneralCommandLine withEnvironment(@Nullable Map<String, String> environment) {
        if (environment != null) {
            this.getEnvironment().putAll(environment);
        }
        return this;
    }

    @NotNull
    public GeneralCommandLine withEnvironment(@NotNull String key, @NotNull String value) {
        this.getEnvironment().put(key, value);
        return this;
    }

    public boolean isPassParentEnvironment() {
        return this.myParentEnvironmentType != ParentEnvironmentType.NONE;
    }

    public void setPassParentEnvironment(boolean passParentEnvironment) {
        this.withParentEnvironmentType(passParentEnvironment ? ParentEnvironmentType.CONSOLE : ParentEnvironmentType.NONE);
    }

    @NotNull
    public ParentEnvironmentType getParentEnvironmentType() {
        return this.myParentEnvironmentType;
    }

    @NotNull
    public GeneralCommandLine withParentEnvironmentType(@NotNull ParentEnvironmentType type) {
        this.myParentEnvironmentType = type;
        return this;
    }

    @NotNull
    public Map<String, String> getParentEnvironment() {
        switch (this.myParentEnvironmentType) {
            case SYSTEM: {
                return System.getenv();
            }
            case CONSOLE: {
                return EnvironmentUtil.getEnvironmentMap();
            }
        }
        return Collections.emptyMap();
    }

    @NotNull
    public Map<String, String> getEffectiveEnvironment() {
        MyTHashMap env = new MyTHashMap();
        this.setupEnvironment((Map<String, String>)((Object)env));
        return env;
    }

    public void addParameters(String ... parameters) {
        this.withParameters(parameters);
    }

    public void addParameters(@NotNull List<String> parameters) {
        this.withParameters(parameters);
    }

    @NotNull
    public GeneralCommandLine withParameters(String ... parameters) {
        for (String parameter : parameters) {
            this.addParameter(parameter);
        }
        return this;
    }

    @NotNull
    public GeneralCommandLine withParameters(@NotNull List<String> parameters) {
        for (String parameter : parameters) {
            this.addParameter(parameter);
        }
        return this;
    }

    public void addParameter(@NotNull String parameter) {
        this.myProgramParams.add(parameter);
    }

    @NotNull
    public ParametersList getParametersList() {
        return this.myProgramParams;
    }

    @NotNull
    public Charset getCharset() {
        return this.myCharset;
    }

    @NotNull
    public GeneralCommandLine withCharset(@NotNull Charset charset) {
        this.myCharset = charset;
        return this;
    }

    public void setCharset(@NotNull Charset charset) {
        this.withCharset(charset);
    }

    public boolean isRedirectErrorStream() {
        return this.myRedirectErrorStream;
    }

    @NotNull
    public GeneralCommandLine withRedirectErrorStream(boolean redirectErrorStream) {
        this.myRedirectErrorStream = redirectErrorStream;
        return this;
    }

    public void setRedirectErrorStream(boolean redirectErrorStream) {
        this.withRedirectErrorStream(redirectErrorStream);
    }

    @NotNull
    public String getCommandLineString() {
        return this.getCommandLineString(null);
    }

    @NotNull
    public String getCommandLineString(@Nullable String exeName) {
        return ParametersList.join(this.getCommandLineList(exeName));
    }

    @NotNull
    public List<String> getCommandLineList(@Nullable String exeName) {
        ArrayList<String> commands = new ArrayList<String>();
        if (exeName != null) {
            commands.add(exeName);
        } else if (this.myExePath != null) {
            commands.add(this.myExePath);
        } else {
            commands.add("<null>");
        }
        commands.addAll(this.myProgramParams.getList());
        return commands;
    }

    @NotNull
    public String getPreparedCommandLine(@NotNull Platform platform) {
        String exePath = this.myExePath != null ? this.myExePath : "";
        return StringUtil.join((Collection)CommandLineUtil.toCommandLine((String)exePath, this.myProgramParams.getList(), (Platform)platform), (String)"\n");
    }

    @NotNull
    public Process createProcess() throws ExecutionException {
        List commands;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing [" + this.getCommandLineString() + "]");
            LOG.debug("  environment: " + this.myEnvParams + " (+" + (Object)((Object)this.myParentEnvironmentType) + ")");
            LOG.debug("  charset: " + this.myCharset);
        }
        try {
            this.checkWorkingDirectory();
            if (StringUtil.isEmptyOrSpaces((String)this.myExePath)) {
                throw new ExecutionException(IdeBundle.message("run.configuration.error.executable.not.specified", new Object[0]));
            }
            commands = CommandLineUtil.toCommandLine((String)this.myExePath, this.myProgramParams.getList());
        }
        catch (ExecutionException e) {
            LOG.info((Throwable)e);
            throw e;
        }
        try {
            return this.startProcess(commands);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            throw new ProcessNotCreatedException(e.getMessage(), e, this);
        }
    }

    @NotNull
    protected Process startProcess(@NotNull List<String> commands) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(commands);
        this.setupEnvironment(builder.environment());
        builder.directory(this.myWorkDirectory);
        builder.redirectErrorStream(this.myRedirectErrorStream);
        return builder.start();
    }

    private void checkWorkingDirectory() throws ExecutionException {
        if (this.myWorkDirectory == null) {
            return;
        }
        if (!this.myWorkDirectory.exists()) {
            throw new ExecutionException(IdeBundle.message("run.configuration.error.working.directory.does.not.exist", this.myWorkDirectory));
        }
        if (!this.myWorkDirectory.isDirectory()) {
            throw new ExecutionException(IdeBundle.message("run.configuration.error.working.directory.not.directory", this.myWorkDirectory));
        }
    }

    protected void setupEnvironment(@NotNull Map<String, String> environment) {
        File workDirectory;
        environment.clear();
        if (this.myParentEnvironmentType != ParentEnvironmentType.NONE) {
            environment.putAll(this.getParentEnvironment());
        }
        if (SystemInfo.isUnix && (workDirectory = this.getWorkDirectory()) != null) {
            environment.put("PWD", FileUtil.toSystemDependentName((String)workDirectory.getAbsolutePath()));
        }
        if (!this.myEnvParams.isEmpty()) {
            if (SystemInfo.isWindows) {
                THashMap envVars = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
                envVars.putAll(environment);
                envVars.putAll(this.myEnvParams);
                environment.clear();
                environment.putAll((Map<String, String>)envVars);
            } else {
                environment.putAll(this.myEnvParams);
            }
        }
    }

    @NotNull
    public static String inescapableQuote(@NotNull String parameter) {
        return CommandLineUtil.specialQuote((String)parameter);
    }

    public String toString() {
        return this.myExePath + " " + this.myProgramParams;
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (this.myUserData != null) {
            Object t = this.myUserData.get(key);
            return (T)t;
        }
        return null;
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (this.myUserData == null) {
            if (value == null) {
                return;
            }
            this.myUserData = ContainerUtil.newHashMap();
        }
        this.myUserData.put(key, value);
    }

    private static class MyTHashMap
    extends THashMap<String, String> {
        private MyTHashMap() {
            super((TObjectHashingStrategy)(SystemInfo.isWindows ? CaseInsensitiveStringHashingStrategy.INSTANCE : ContainerUtil.canonicalStrategy()));
        }

        public String put(String key, String value) {
            if (key == null || value == null) {
                LOG.error((Throwable)new Exception("Nulls are not allowed"));
                return null;
            }
            if (key.isEmpty()) {
                LOG.warn("Skipping environment variable with empty name, value: " + value);
                return null;
            }
            return (String)super.put((Object)key, (Object)value);
        }

        public void putAll(Map<? extends String, ? extends String> map) {
            if (map != null) {
                super.putAll(map);
            }
        }
    }

    public static enum ParentEnvironmentType {
        NONE,
        SYSTEM,
        CONSOLE;

    }
}

