/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.ModuleRunConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.xmlb.annotations.Property;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class ModuleBasedConfiguration<ConfigurationModule extends RunConfigurationModule>
extends LocatableConfigurationBase
implements Cloneable,
ModuleRunConfiguration {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.configurations.ModuleBasedConfiguration");
    @Property(surroundWithTag=false)
    private final ConfigurationModule myModule;
    @NonNls
    protected static final String TO_CLONE_ELEMENT_NAME = "toClone";

    public ModuleBasedConfiguration(String name, @NotNull ConfigurationModule configurationModule, @NotNull ConfigurationFactory factory) {
        super(((RunConfigurationModule)configurationModule).getProject(), factory, name);
        this.myModule = configurationModule;
    }

    public ModuleBasedConfiguration(ConfigurationModule configurationModule, ConfigurationFactory factory) {
        super(((RunConfigurationModule)configurationModule).getProject(), factory, "");
        this.myModule = configurationModule;
    }

    public abstract Collection<Module> getValidModules();

    public ConfigurationModule getConfigurationModule() {
        return this.myModule;
    }

    public void setModule(Module module) {
        ((RunConfigurationModule)this.myModule).setModule(module);
    }

    protected void readModule(Element element) {
        ((RunConfigurationModule)this.myModule).readExternal(element);
    }

    protected void writeModule(Element element) {
        ((RunConfigurationModule)this.myModule).writeExternal(element);
    }

    public Collection<Module> getAllModules() {
        return Arrays.asList(ModuleManager.getInstance(this.getProject()).getModules());
    }

    protected ModuleBasedConfiguration createInstance() {
        ModuleBasedConfiguration configuration = (ModuleBasedConfiguration)this.getFactory().createTemplateConfiguration(this.getProject());
        configuration.setName(this.getName());
        return configuration;
    }

    @Override
    public ModuleBasedConfiguration clone() {
        Element element = new Element(TO_CLONE_ELEMENT_NAME);
        try {
            this.writeExternal(element);
            RunConfiguration configuration = this.getFactory().createTemplateConfiguration(this.getProject());
            configuration.setName(this.getName());
            configuration.readExternal(element);
            return (ModuleBasedConfiguration)configuration;
        }
        catch (InvalidDataException | WriteExternalException e) {
            LOG.error(e);
            return null;
        }
    }

    @Override
    @NotNull
    public Module[] getModules() {
        Module[] moduleArray;
        Module module = (Module)ReadAction.compute(() -> ((RunConfigurationModule)this.getConfigurationModule()).getModule());
        if (module == null) {
            moduleArray = Module.EMPTY_ARRAY;
        } else {
            Module[] moduleArray2 = new Module[1];
            moduleArray = moduleArray2;
            moduleArray2[0] = module;
        }
        return moduleArray;
    }

    public void restoreOriginalModule(Module originalModule) {
        if (originalModule == null) {
            return;
        }
        THashSet modules = new THashSet();
        for (Module classModule : this.getModules()) {
            ModuleUtilCore.collectModulesDependsOn(classModule, (Set<Module>)modules);
        }
        if (modules.contains(originalModule)) {
            this.setModule(originalModule);
        }
    }

    public void onNewConfigurationCreated() {
        ConfigurationModule configurationModule = this.getConfigurationModule();
        if (((RunConfigurationModule)configurationModule).getModule() == null) {
            Module[] modules = ModuleManager.getInstance(this.getProject()).getModules();
            ((RunConfigurationModule)configurationModule).setModule(modules.length == 1 ? modules[0] : null);
        }
    }
}

