/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.diagnostic.Logger;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ParamsGroup
implements Cloneable {
    private static final Logger LOG = Logger.getInstance((String)ParamsGroup.class.getName());
    private String myGroupId;
    private ParametersList myGroupParams = new ParametersList();

    public ParamsGroup(@NotNull String groupId) {
        this.myGroupId = groupId;
    }

    public String getId() {
        return this.myGroupId;
    }

    public void addParameter(@NotNull @NonNls String parameter) {
        this.myGroupParams.add(parameter);
    }

    public void addParameterAt(int index, @NotNull @NonNls String parameter) {
        this.myGroupParams.addAt(index, parameter);
    }

    public void addParameters(String ... parameters) {
        for (String parameter : parameters) {
            this.addParameter(parameter);
        }
    }

    public void addParameters(@NotNull List<String> parameters) {
        for (String parameter : parameters) {
            this.addParameter(parameter);
        }
    }

    public void addParametersString(@NotNull @NonNls String parametersString) {
        this.addParameters(ParametersList.parse(parametersString));
    }

    public List<String> getParameters() {
        return this.myGroupParams.getList();
    }

    public ParametersList getParametersList() {
        return this.myGroupParams;
    }

    public ParamsGroup clone() {
        try {
            ParamsGroup clone = (ParamsGroup)super.clone();
            clone.myGroupId = this.myGroupId;
            clone.myGroupParams = this.myGroupParams.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public String toString() {
        return this.myGroupId;
    }
}

