/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.SearchScopeProvidingRunProfile;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchScopeProvider {
    @NotNull
    public static GlobalSearchScope createSearchScope(@NotNull Project project, @Nullable RunProfile runProfile) {
        GlobalSearchScope scope;
        if (runProfile instanceof SearchScopeProvidingRunProfile && (scope = ((SearchScopeProvidingRunProfile)runProfile).getSearchScope()) != null) {
            return scope;
        }
        return GlobalSearchScope.allScope(project);
    }

    @Nullable
    public static GlobalSearchScope createSearchScope(@NotNull Module[] modules) {
        if (modules.length == 0) {
            return null;
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleRuntimeScope(modules[0], true);
        for (int idx = 1; idx < modules.length; ++idx) {
            Module module = modules[idx];
            scope = scope.uniteWith(GlobalSearchScope.moduleRuntimeScope(module, true));
        }
        return scope;
    }
}

