/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.intellij.execution.dashboard.TreeContent;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DashboardTreeAction<T, C extends TreeContent>
extends AnAction {
    protected DashboardTreeAction(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        List<T> targetNodes = this.getTargetNodes(e);
        boolean visible = this.isVisibleForAnySelection(e) || !targetNodes.isEmpty() && targetNodes.stream().allMatch(this::isVisible4);
        boolean enabled = visible && !targetNodes.isEmpty() && targetNodes.stream().allMatch(this::isEnabled4);
        presentation.setVisible(visible);
        presentation.setEnabled(enabled);
        this.updatePresentation(presentation, ContainerUtil.getFirstItem(targetNodes));
    }

    @NotNull
    protected List<T> getTargetNodes(AnActionEvent e) {
        C content = this.getTreeContent(e);
        if (content == null) {
            return Collections.emptyList();
        }
        Set<?> selectedElements = this.collectNodes(content.getBuilder());
        int selectionCount = selectedElements.size();
        if (selectionCount == 0 || selectionCount > 1 && !this.isMultiSelectionAllowed()) {
            return Collections.emptyList();
        }
        Class<T> targetNodeClass = this.getTargetNodeClass();
        ArrayList<T> result = new ArrayList<T>();
        for (Object selectedElement : selectedElements) {
            if (!targetNodeClass.isInstance(selectedElement)) {
                return Collections.emptyList();
            }
            result.add(targetNodeClass.cast(selectedElement));
        }
        return result;
    }

    @NotNull
    protected Set<?> collectNodes(@NotNull AbstractTreeBuilder treeBuilder) {
        return treeBuilder.getSelectedElements();
    }

    protected abstract C getTreeContent(AnActionEvent var1);

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        List verifiedTargetNodes = this.getTargetNodes(e).stream().filter(node -> this.isVisible4(node) && this.isEnabled4(node)).collect(Collectors.toList());
        this.doActionPerformed(this.getTreeContent(e), e, (T)verifiedTargetNodes);
    }

    protected boolean isVisibleForAnySelection(@NotNull AnActionEvent e) {
        return false;
    }

    protected boolean isMultiSelectionAllowed() {
        return false;
    }

    protected boolean isVisible4(T node) {
        return true;
    }

    protected boolean isEnabled4(T node) {
        return true;
    }

    protected void updatePresentation(@NotNull Presentation presentation, @Nullable T node) {
    }

    protected void doActionPerformed(@NotNull C content, AnActionEvent e, List<T> nodes) {
        nodes.forEach(node -> this.doActionPerformed(content, e, node));
    }

    protected void doActionPerformed(@NotNull C content, AnActionEvent e, T node) {
        this.doActionPerformed(node);
    }

    protected void doActionPerformed(T node) {
        throw new UnsupportedOperationException();
    }

    protected abstract Class<T> getTargetNodeClass();
}

