/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.FilterMixin;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeFilter
implements Filter,
FilterMixin {
    private static final Logger LOG = Logger.getInstance(CompositeFilter.class);
    private final List<Filter> myFilters;
    private boolean myIsAnyHeavy;
    private boolean forceUseAllFilters;
    private final DumbService myDumbService;

    public CompositeFilter(@NotNull Project project) {
        this(project, new ArrayList<Filter>());
    }

    public CompositeFilter(@NotNull Project project, @NotNull List<Filter> filters) {
        this.myDumbService = DumbService.getInstance(project);
        this.myFilters = filters;
        this.myFilters.forEach(filter -> this.myIsAnyHeavy |= filter instanceof FilterMixin);
    }

    protected CompositeFilter(DumbService dumbService) {
        this.myDumbService = dumbService;
        this.myFilters = new ArrayList<Filter>();
    }

    @Override
    @Nullable
    public Filter.Result applyFilter(String line, int entireLength) {
        boolean dumb = this.myDumbService.isDumb();
        List<Filter> filters = this.myFilters;
        int count = filters.size();
        List<Filter.ResultItem> resultItems = null;
        for (int i2 = 0; i2 < count; ++i2) {
            Filter.Result result;
            ProgressManager.checkCanceled();
            Filter filter = filters.get(i2);
            if (dumb && !DumbService.isDumbAware(filter)) continue;
            long t0 = System.currentTimeMillis();
            try {
                result = filter.applyFilter(line, entireLength);
            }
            catch (ProcessCanceledException ignore) {
                result = null;
            }
            catch (Throwable t) {
                throw new RuntimeException("Error while applying " + filter + " to '" + line + "'", t);
            }
            resultItems = this.merge(resultItems, result, entireLength, filter);
            t0 = System.currentTimeMillis() - t0;
            if (t0 > 1000L) {
                LOG.warn(filter.getClass().getSimpleName() + ".applyFilter() took " + t0 + " ms on '''" + line + "'''");
            }
            if (this.shouldStopFiltering(result)) break;
        }
        return CompositeFilter.createFinalResult(resultItems);
    }

    @Nullable
    private static Filter.Result createFinalResult(@Nullable List<Filter.ResultItem> resultItems) {
        if (resultItems == null) {
            return null;
        }
        if (resultItems.size() == 1) {
            final Filter.ResultItem resultItem = resultItems.get(0);
            return new Filter.Result(resultItem.getHighlightStartOffset(), resultItem.getHighlightEndOffset(), resultItem.getHyperlinkInfo(), resultItem.getHighlightAttributes(), resultItem.getFollowedHyperlinkAttributes()){

                @Override
                public int getHighlighterLayer() {
                    return resultItem.getHighlighterLayer();
                }
            };
        }
        return new Filter.Result(resultItems);
    }

    private boolean shouldStopFiltering(@Nullable Filter.Result result) {
        return result != null && result.getNextAction() == Filter.NextAction.EXIT && !this.forceUseAllFilters;
    }

    @Nullable
    private List<Filter.ResultItem> merge(@Nullable List<Filter.ResultItem> resultItems, @Nullable Filter.Result newResult, int entireLength, Filter filter) {
        if (newResult != null) {
            if (resultItems == null) {
                resultItems = new ArrayList<Filter.ResultItem>();
            }
            List<Filter.ResultItem> newItems = newResult.getResultItems();
            for (int i2 = 0; i2 < newItems.size(); ++i2) {
                Filter.ResultItem item = newItems.get(i2);
                if (item.getHyperlinkInfo() != null && this.intersects(resultItems, item) || !CompositeFilter.checkOffsetsCorrect(item, entireLength, filter)) continue;
                resultItems.add(item);
            }
        }
        return resultItems;
    }

    private static boolean checkOffsetsCorrect(Filter.ResultItem item, int entireLength, Filter filter) {
        int start = item.getHighlightStartOffset();
        int end = item.getHighlightEndOffset();
        if (end < start || end > entireLength) {
            LOG.error("Filter returned wrong range: start=" + start + "; end=" + end + "; length=" + entireLength + "; filter=" + filter);
            return false;
        }
        return true;
    }

    protected boolean intersects(List<Filter.ResultItem> items, Filter.ResultItem newItem) {
        TextRange newItemTextRange = null;
        for (int i2 = 0; i2 < items.size(); ++i2) {
            Filter.ResultItem item = items.get(i2);
            if (item.getHyperlinkInfo() == null) continue;
            if (newItemTextRange == null) {
                newItemTextRange = new TextRange(newItem.highlightStartOffset, newItem.highlightEndOffset);
            }
            if (!newItemTextRange.intersectsStrict(item.highlightStartOffset, item.highlightEndOffset)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldRunHeavy() {
        for (Filter filter : this.myFilters) {
            if (!(filter instanceof FilterMixin) || !((FilterMixin)((Object)filter)).shouldRunHeavy()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void applyHeavyFilter(@NotNull Document copiedFragment, int startOffset, int startLineNumber, @NotNull Consumer<FilterMixin.AdditionalHighlight> consumer) {
        boolean dumb = this.myDumbService.isDumb();
        List<Filter> filters = this.myFilters;
        int count = filters.size();
        for (int i2 = 0; i2 < count; ++i2) {
            Filter filter = filters.get(i2);
            if (!(filter instanceof FilterMixin) || !((FilterMixin)((Object)filter)).shouldRunHeavy() || dumb && !DumbService.isDumbAware(filter)) continue;
            ((FilterMixin)((Object)filter)).applyHeavyFilter(copiedFragment, startOffset, startLineNumber, consumer);
        }
    }

    @Override
    @NotNull
    public String getUpdateMessage() {
        boolean dumb = this.myDumbService.isDumb();
        List<Filter> filters = this.myFilters;
        ArrayList<String> updateMessage = new ArrayList<String>();
        int count = filters.size();
        for (int i2 = 0; i2 < count; ++i2) {
            Filter filter = filters.get(i2);
            if (!(filter instanceof FilterMixin) || !((FilterMixin)((Object)filter)).shouldRunHeavy() || dumb && !DumbService.isDumbAware(filter)) continue;
            updateMessage.add(((FilterMixin)((Object)filter)).getUpdateMessage());
        }
        return updateMessage.size() == 1 ? (String)updateMessage.get(0) : "Updating...";
    }

    public boolean isEmpty() {
        return this.myFilters.isEmpty();
    }

    public boolean isAnyHeavy() {
        return this.myIsAnyHeavy;
    }

    public void addFilter(@NotNull Filter filter) {
        this.myFilters.add(filter);
        this.myIsAnyHeavy |= filter instanceof FilterMixin;
    }

    @NotNull
    public List<Filter> getFilters() {
        return Collections.unmodifiableList(this.myFilters);
    }

    public void setForceUseAllFilters(boolean forceUseAllFilters) {
        this.forceUseAllFilters = forceUseAllFilters;
    }

    public String toString() {
        return "CompositeFilter: " + this.myFilters;
    }
}

