/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.ColoredOutputTypeRegistry;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnsiEscapeDecoder {
    private static final char ESC_CHAR = '\u001b';
    private static final String CSI = "\u001b[";
    private static final String M_CSI = "m\u001b[";
    private static final char BACKSPACE = '\b';
    private final ColoredOutputTypeRegistry myColoredOutputTypeRegistry = ColoredOutputTypeRegistry.getInstance();
    private Key myCurrentTextAttributes;
    private String myUnhandledStdout;
    private String myUnhandledStderr;

    public void escapeText(@NotNull String text, @NotNull Key outputType, @NotNull ColoredTextAcceptor textAcceptor) {
        text = this.prependUnhandledText(text, outputType);
        text = AnsiEscapeDecoder.normalizeAsciiControlCharacters(text);
        int pos = 0;
        List<Pair<String, Key>> chunks = null;
        int unhandledSuffixLength = 0;
        while (true) {
            int escSeqEndInd;
            int escSeqBeginInd;
            if ((escSeqBeginInd = AnsiEscapeDecoder.findEscSeqBeginIndex(text, pos)) < 0) {
                if (escSeqBeginInd >= -1) break;
                unhandledSuffixLength = AnsiEscapeDecoder.decodeUnhandledSuffixLength(escSeqBeginInd);
                break;
            }
            if (pos < escSeqBeginInd) {
                chunks = this.processTextChunk(chunks, text.substring(pos, escSeqBeginInd), outputType, textAcceptor);
            }
            if ((escSeqEndInd = AnsiEscapeDecoder.findConsecutiveEscSequencesEndIndex(text, escSeqBeginInd)) < 0) {
                if (escSeqEndInd >= -1) break;
                unhandledSuffixLength = AnsiEscapeDecoder.decodeUnhandledSuffixLength(escSeqEndInd);
                break;
            }
            if (text.charAt(escSeqEndInd) == 'm') {
                String escSeq = text.substring(escSeqBeginInd, escSeqEndInd + 1);
                String colorAttribute = StringUtil.replace((String)escSeq, (String)M_CSI, (String)";");
                this.myCurrentTextAttributes = this.myColoredOutputTypeRegistry.getOutputKey(colorAttribute);
            }
            pos = escSeqEndInd + 1;
        }
        this.updateUnhandledSuffix(text, outputType, unhandledSuffixLength);
        if (unhandledSuffixLength == 0 && pos < text.length()) {
            chunks = this.processTextChunk(chunks, text.substring(pos), outputType, textAcceptor);
        }
        if (chunks != null && textAcceptor instanceof ColoredChunksAcceptor) {
            ((ColoredChunksAcceptor)textAcceptor).coloredChunksAvailable(chunks);
        }
    }

    private void updateUnhandledSuffix(@NotNull String text, @NotNull Key outputType, int unhandledSuffixLength) {
        String unhandledSuffix;
        String string = unhandledSuffix = unhandledSuffixLength > 0 ? text.substring(text.length() - unhandledSuffixLength) : null;
        if (outputType == ProcessOutputTypes.STDOUT) {
            this.myUnhandledStdout = unhandledSuffix;
        } else if (outputType == ProcessOutputTypes.STDERR) {
            this.myUnhandledStderr = unhandledSuffix;
        }
    }

    @NotNull
    private String prependUnhandledText(@NotNull String text, @NotNull Key outputType) {
        String prevUnhandledText = null;
        if (outputType == ProcessOutputTypes.STDOUT) {
            prevUnhandledText = this.myUnhandledStdout;
            this.myUnhandledStdout = null;
        } else if (outputType == ProcessOutputTypes.STDERR) {
            prevUnhandledText = this.myUnhandledStderr;
            this.myUnhandledStderr = null;
        }
        return prevUnhandledText != null ? prevUnhandledText + text : text;
    }

    @NotNull
    private static String normalizeAsciiControlCharacters(@NotNull String text) {
        int ind = text.indexOf(8);
        if (ind == -1) {
            return text;
        }
        StringBuilder result = new StringBuilder();
        int i2 = 0;
        int guardIndex = 0;
        boolean removalFromPrevTextAttempted = false;
        while (i2 < text.length()) {
            LineSeparator lineSeparator = StringUtil.getLineSeparatorAt((CharSequence)text, (int)i2);
            if (lineSeparator != null) {
                i2 += lineSeparator.getSeparatorString().length();
                result.append(lineSeparator.getSeparatorString());
                guardIndex = result.length();
                continue;
            }
            if (text.charAt(i2) == '\b') {
                if (result.length() > guardIndex) {
                    result.setLength(result.length() - 1);
                } else if (guardIndex == 0) {
                    removalFromPrevTextAttempted = true;
                }
            } else {
                result.append(text.charAt(i2));
            }
            ++i2;
        }
        if (removalFromPrevTextAttempted) {
            result.insert(0, LineSeparator.LF.getSeparatorString());
        }
        return result.toString();
    }

    private static int findEscSeqBeginIndex(@NotNull String text, int fromIndex) {
        int ind = text.indexOf(CSI.charAt(0), fromIndex);
        if (ind == -1) {
            return -1;
        }
        if (ind == text.length() - 1) {
            return AnsiEscapeDecoder.encodeUnhandledSuffixLength(text, ind);
        }
        return text.charAt(ind + 1) == CSI.charAt(1) ? ind : -1;
    }

    private static int findConsecutiveEscSequencesEndIndex(@NotNull String text, int firstEscSeqBeginInd) {
        int escSeqEndInd;
        int escSeqBeginInd = firstEscSeqBeginInd;
        int lastMatchedColorEscSeqEndInd = -1;
        while ((escSeqEndInd = AnsiEscapeDecoder.findEscSeqEndIndex(text, escSeqBeginInd)) >= 0) {
            if (text.charAt(escSeqEndInd) != 'm') {
                return lastMatchedColorEscSeqEndInd > 0 ? lastMatchedColorEscSeqEndInd : escSeqEndInd;
            }
            escSeqBeginInd = escSeqEndInd + 1;
            lastMatchedColorEscSeqEndInd = escSeqEndInd;
            if (escSeqEndInd + 1 >= text.length()) {
                return AnsiEscapeDecoder.encodeUnhandledSuffixLength(text, firstEscSeqBeginInd);
            }
            if (text.charAt(escSeqEndInd + 1) != CSI.charAt(0)) break;
            if (escSeqEndInd + 2 >= text.length()) {
                return AnsiEscapeDecoder.encodeUnhandledSuffixLength(text, firstEscSeqBeginInd);
            }
            if (text.charAt(escSeqEndInd + 2) == CSI.charAt(1)) continue;
        }
        if (escSeqEndInd < -1) {
            return AnsiEscapeDecoder.encodeUnhandledSuffixLength(text, firstEscSeqBeginInd);
        }
        return lastMatchedColorEscSeqEndInd;
    }

    private static int findEscSeqEndIndex(@NotNull String text, int escSeqBeginInd) {
        char ch;
        int parameterEndInd;
        for (parameterEndInd = escSeqBeginInd + CSI.length(); parameterEndInd < text.length() && (Character.isDigit(ch = text.charAt(parameterEndInd)) || ch == ';'); ++parameterEndInd) {
        }
        if (parameterEndInd == text.length()) {
            return AnsiEscapeDecoder.encodeUnhandledSuffixLength(text, escSeqBeginInd);
        }
        return StringUtil.containsChar((String)"ABCDEFGHJKSTfmisu", (char)text.charAt(parameterEndInd)) ? parameterEndInd : -1;
    }

    private static int encodeUnhandledSuffixLength(@NotNull String text, int suffixStartInd) {
        return -1 - (text.length() - suffixStartInd);
    }

    private static int decodeUnhandledSuffixLength(int encodedUnhandledSuffixLength) {
        if (encodedUnhandledSuffixLength >= -1) {
            throw new AssertionError();
        }
        return -encodedUnhandledSuffixLength - 1;
    }

    @Nullable
    private List<Pair<String, Key>> processTextChunk(@Nullable List<Pair<String, Key>> buffer, @NotNull String text, @NotNull Key outputType, @NotNull ColoredTextAcceptor textAcceptor) {
        Key attributes = this.getCurrentOutputAttributes(outputType);
        if (textAcceptor instanceof ColoredChunksAcceptor) {
            if (buffer == null) {
                buffer = ContainerUtil.newArrayListWithCapacity((int)1);
            }
            buffer.add(Pair.create((Object)text, (Object)attributes));
        } else {
            textAcceptor.coloredTextAvailable(text, attributes);
        }
        return buffer;
    }

    @NotNull
    protected Key getCurrentOutputAttributes(@NotNull Key outputType) {
        if (outputType == ProcessOutputTypes.STDERR || outputType == ProcessOutputTypes.SYSTEM) {
            return outputType;
        }
        return this.myCurrentTextAttributes != null ? this.myCurrentTextAttributes : outputType;
    }

    @FunctionalInterface
    public static interface ColoredTextAcceptor {
        public void coloredTextAvailable(@NotNull String var1, @NotNull Key var2);
    }

    public static interface ColoredChunksAcceptor
    extends ColoredTextAcceptor {
        public void coloredChunksAvailable(@NotNull List<Pair<String, Key>> var1);
    }
}

