/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.ConsoleHighlighter;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColoredOutputTypeRegistry {
    private final Map<String, Key> myRegisteredKeys = ContainerUtil.newConcurrentMap();
    private static final TextAttributesKey[] myAnsiColorKeys = new TextAttributesKey[]{ConsoleHighlighter.BLACK, ConsoleHighlighter.RED, ConsoleHighlighter.GREEN, ConsoleHighlighter.YELLOW, ConsoleHighlighter.BLUE, ConsoleHighlighter.MAGENTA, ConsoleHighlighter.CYAN, ConsoleHighlighter.GRAY, ConsoleHighlighter.DARKGRAY, ConsoleHighlighter.RED_BRIGHT, ConsoleHighlighter.GREEN_BRIGHT, ConsoleHighlighter.YELLOW_BRIGHT, ConsoleHighlighter.BLUE_BRIGHT, ConsoleHighlighter.MAGENTA_BRIGHT, ConsoleHighlighter.CYAN_BRIGHT, ConsoleHighlighter.WHITE};

    public static ColoredOutputTypeRegistry getInstance() {
        return ServiceManager.getService(ColoredOutputTypeRegistry.class);
    }

    @NotNull
    public Key getOutputKey(@NonNls String attribute) {
        Key key = this.myRegisteredKeys.get(attribute);
        if (key != null) {
            return key;
        }
        String completeAttribute = attribute;
        attribute = attribute.startsWith("\u001b[") ? attribute.substring(2) : StringUtil.trimStart((String)attribute, (String)"[");
        if ((attribute = StringUtil.trimEnd((String)attribute, (String)"m")).equals("0")) {
            return ProcessOutputTypes.STDOUT;
        }
        Key newKey = new Key(completeAttribute);
        AnsiConsoleViewContentType contentType = ColoredOutputTypeRegistry.createAnsiConsoleViewContentType(attribute);
        ConsoleViewContentType.registerNewConsoleViewType(newKey, contentType);
        this.myRegisteredKeys.put(completeAttribute, newKey);
        return newKey;
    }

    private static Color getAnsiColor(int value) {
        return ColoredOutputTypeRegistry.getColorByKey(ColoredOutputTypeRegistry.getAnsiColorKey(value));
    }

    private static Color getColorByKey(TextAttributesKey colorKey) {
        return EditorColorsManager.getInstance().getGlobalScheme().getAttributes(colorKey).getForegroundColor();
    }

    @NotNull
    private static Color getDefaultForegroundColor() {
        Color color;
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes attr = scheme.getAttributes(ConsoleViewContentType.NORMAL_OUTPUT_KEY);
        Color color2 = color = attr != null ? attr.getForegroundColor() : null;
        if (color == null) {
            color = scheme.getDefaultForeground();
        }
        return color;
    }

    @NotNull
    private static Color getDefaultBackgroundColor() {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        Color color = scheme.getColor(ConsoleViewContentType.CONSOLE_BACKGROUND_KEY);
        if (color == null) {
            color = scheme.getDefaultBackground();
        }
        return color;
    }

    public static TextAttributesKey getAnsiColorKey(int value) {
        if (value >= 16) {
            return ConsoleViewContentType.NORMAL_OUTPUT_KEY;
        }
        return myAnsiColorKeys[value];
    }

    @NotNull
    private static AnsiConsoleViewContentType createAnsiConsoleViewContentType(@NotNull String attribute) {
        String[] strings;
        int foregroundColor = -1;
        int backgroundColor = -1;
        boolean inverse = false;
        EffectType effectType = null;
        int fontType = -1;
        for (String string : strings = attribute.split(";")) {
            int value;
            try {
                value = Integer.parseInt(string);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (value == 1) {
                fontType = 1;
                continue;
            }
            if (value == 4) {
                effectType = EffectType.LINE_UNDERSCORE;
                continue;
            }
            if (value == 7) {
                inverse = true;
                continue;
            }
            if (value == 22) {
                fontType = 0;
                continue;
            }
            if (value == 24) {
                effectType = null;
                continue;
            }
            if (value >= 30 && value <= 37) {
                foregroundColor = value - 30;
                continue;
            }
            if (value == 38) continue;
            if (value == 39) {
                foregroundColor = -1;
                continue;
            }
            if (value >= 40 && value <= 47) {
                backgroundColor = value - 40;
                continue;
            }
            if (value == 48) continue;
            if (value == 49) {
                backgroundColor = -1;
                continue;
            }
            if (value >= 90 && value <= 97) {
                foregroundColor = value - 82;
                continue;
            }
            if (value < 100 || value > 107) continue;
            backgroundColor = value - 92;
        }
        return new AnsiConsoleViewContentType(attribute, backgroundColor, foregroundColor, inverse, effectType, fontType);
    }

    private static class AnsiConsoleViewContentType
    extends ConsoleViewContentType {
        private final int myBackgroundColor;
        private final int myForegroundColor;
        private final boolean myInverse;
        private final EffectType myEffectType;
        private final int myFontType;

        private AnsiConsoleViewContentType(@NotNull String attribute, int backgroundColor, int foregroundColor, boolean inverse, @Nullable EffectType effectType, int fontType) {
            super(attribute, ConsoleViewContentType.NORMAL_OUTPUT_KEY);
            this.myBackgroundColor = backgroundColor;
            this.myForegroundColor = foregroundColor;
            this.myInverse = inverse;
            this.myEffectType = effectType;
            this.myFontType = fontType;
        }

        @Override
        public TextAttributes getAttributes() {
            TextAttributes attrs = new TextAttributes();
            attrs.setEffectType(this.myEffectType);
            if (this.myFontType != -1) {
                attrs.setFontType(this.myFontType);
            }
            Color foregroundColor = this.getForegroundColor();
            Color backgroundColor = this.getBackgroundColor();
            if (this.myInverse) {
                attrs.setForegroundColor(backgroundColor);
                attrs.setEffectColor(backgroundColor);
                attrs.setBackgroundColor(foregroundColor);
            } else {
                attrs.setForegroundColor(foregroundColor);
                attrs.setEffectColor(foregroundColor);
                attrs.setBackgroundColor(backgroundColor);
            }
            return attrs;
        }

        private Color getForegroundColor() {
            return this.myForegroundColor != -1 ? ColoredOutputTypeRegistry.getAnsiColor(this.myForegroundColor) : ColoredOutputTypeRegistry.getDefaultForegroundColor();
        }

        private Color getBackgroundColor() {
            return this.myBackgroundColor != -1 ? ColoredOutputTypeRegistry.getAnsiColor(this.myBackgroundColor) : ColoredOutputTypeRegistry.getDefaultBackgroundColor();
        }
    }
}

